/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.paimon.flink.VersionedSerializerWrapper;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.CommittableStateManager;
import org.apache.paimon.flink.sink.Committer;
import org.apache.paimon.flink.sink.FlinkSink;
import org.apache.paimon.flink.sink.RestoreAndFailCommittableStateManager;
import org.apache.paimon.flink.sink.StoreCommitter;
import org.apache.paimon.manifest.ManifestCommittable;
import org.apache.paimon.manifest.ManifestCommittableSerializer;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.TableCommitImpl;

public abstract class FlinkWriteSink<T>
extends FlinkSink<T> {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final Map<String, String> overwritePartition;

    public FlinkWriteSink(FileStoreTable table, @Nullable Map<String, String> overwritePartition) {
        super(table, overwritePartition != null);
        this.overwritePartition = overwritePartition;
    }

    @Override
    protected Committer.Factory<Committable, ManifestCommittable> createCommitterFactory(boolean streamingCheckpointEnabled) {
        return (user, metricGroup) -> new StoreCommitter(((TableCommitImpl)this.table.newCommit(user).withOverwrite((Map)this.overwritePartition)).ignoreEmptyCommit(!streamingCheckpointEnabled), metricGroup);
    }

    @Override
    protected CommittableStateManager<ManifestCommittable> createCommittableStateManager() {
        return new RestoreAndFailCommittableStateManager<ManifestCommittable>(() -> new VersionedSerializerWrapper<ManifestCommittable>(new ManifestCommittableSerializer()));
    }
}

