/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.index;

import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.paimon.crosspartition.GlobalIndexAssigner;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.index.KeyPartOrRow;
import org.apache.paimon.flink.utils.ManagedMemoryUtils;
import org.apache.paimon.table.Table;

public class GlobalIndexAssignerOperator
extends AbstractStreamOperator<Tuple2<InternalRow, Integer>>
implements OneInputStreamOperator<Tuple2<KeyPartOrRow, InternalRow>, Tuple2<InternalRow, Integer>>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final GlobalIndexAssigner assigner;
    private transient org.apache.paimon.disk.IOManager ioManager;

    public GlobalIndexAssignerOperator(GlobalIndexAssigner assigner) {
        this.assigner = assigner;
    }

    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        IOManager flinkIoManager = this.getContainingTask().getEnvironment().getIOManager();
        this.ioManager = org.apache.paimon.disk.IOManager.create(flinkIoManager.getSpillingDirectoriesPaths());
        this.assigner.open(ManagedMemoryUtils.computeManagedMemory(this), this.ioManager, this.getRuntimeContext().getNumberOfParallelSubtasks(), this.getRuntimeContext().getIndexOfThisSubtask(), this::collect);
    }

    public void processElement(StreamRecord<Tuple2<KeyPartOrRow, InternalRow>> streamRecord) throws Exception {
        Tuple2 tuple2 = (Tuple2)streamRecord.getValue();
        InternalRow value = (InternalRow)tuple2.f1;
        switch ((KeyPartOrRow)((Object)tuple2.f0)) {
            case KEY_PART: {
                this.assigner.bootstrapKey(value);
                break;
            }
            case ROW: {
                this.assigner.processInput(value);
            }
        }
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        this.endBootstrap(false);
    }

    public void endInput() throws Exception {
        this.endBootstrap(true);
    }

    private void endBootstrap(boolean isEndInput) throws Exception {
        if (this.assigner.inBoostrap()) {
            this.assigner.endBoostrap(isEndInput);
        }
    }

    private void collect(InternalRow value, int bucket) {
        this.output.collect((Object)new StreamRecord((Object)new Tuple2((Object)value, (Object)bucket)));
    }

    public void close() throws Exception {
        this.assigner.close();
        if (this.ioManager != null) {
            this.ioManager.close();
        }
    }

    public static GlobalIndexAssignerOperator forRowData(Table table) {
        return new GlobalIndexAssignerOperator(new GlobalIndexAssigner(table));
    }
}

