/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.align;

import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.api.connector.source.ExternallyInducedSourceReader;
import org.apache.flink.api.connector.source.SourceEvent;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.data.RowData;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.flink.source.FileStoreSourceReader;
import org.apache.paimon.flink.source.FileStoreSourceSplit;
import org.apache.paimon.flink.source.FileStoreSourceSplitState;
import org.apache.paimon.flink.source.align.CheckpointEvent;
import org.apache.paimon.flink.source.metrics.FileStoreSourceReaderMetrics;
import org.apache.paimon.table.source.TableRead;

public class AlignedSourceReader
extends FileStoreSourceReader
implements ExternallyInducedSourceReader<RowData, FileStoreSourceSplit> {
    private final FutureCompletingBlockingQueue<RecordsWithSplitIds<BulkFormat.RecordIterator<RowData>>> elementsQueue;
    private Long nextCheckpointId;

    public AlignedSourceReader(SourceReaderContext readerContext, TableRead tableRead, FileStoreSourceReaderMetrics metrics, IOManager ioManager, @Nullable Long limit, FutureCompletingBlockingQueue<RecordsWithSplitIds<BulkFormat.RecordIterator<RowData>>> elementsQueue) {
        super(readerContext, tableRead, metrics, ioManager, limit, elementsQueue);
        this.elementsQueue = elementsQueue;
        this.nextCheckpointId = null;
    }

    public void handleSourceEvents(SourceEvent sourceEvent) {
        if (sourceEvent instanceof CheckpointEvent) {
            this.nextCheckpointId = ((CheckpointEvent)sourceEvent).getCheckpointId();
            this.elementsQueue.notifyAvailable();
        } else {
            super.handleSourceEvents(sourceEvent);
        }
    }

    @Override
    protected void onSplitFinished(Map<String, FileStoreSourceSplitState> finishedSplitIds) {
    }

    public Optional<Long> shouldTriggerCheckpoint() {
        if (this.getNumberOfCurrentlyAssignedSplits() == 0 && this.nextCheckpointId != null) {
            long checkpointId = this.nextCheckpointId;
            this.nextCheckpointId = null;
            this.context.sendSplitRequest();
            return Optional.of(checkpointId);
        }
        return Optional.empty();
    }
}

