/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.flink.FlinkCatalog;
import org.apache.paimon.flink.FlinkCatalogOptions;
import org.apache.paimon.flink.FlinkFileIOLoader;
import org.apache.paimon.flink.FlinkGenericCatalog;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;

public class FlinkGenericCatalogFactory
implements CatalogFactory {
    public static final String IDENTIFIER = "paimon-generic";

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return Collections.emptySet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return Collections.emptySet();
    }

    public FlinkGenericCatalog createCatalog(CatalogFactory.Context context) {
        CatalogFactory hiveFactory = FlinkGenericCatalogFactory.createHiveCatalogFactory(context.getClassLoader());
        CatalogFactory.Context filteredContext = this.filterContextOptions(context, hiveFactory);
        Catalog catalog = hiveFactory.createCatalog(filteredContext);
        return FlinkGenericCatalogFactory.createCatalog(context.getClassLoader(), context.getOptions(), context.getName(), catalog);
    }

    @VisibleForTesting
    public CatalogFactory.Context filterContextOptions(CatalogFactory.Context context, CatalogFactory catalogFactory) {
        HashSet catalogOptions = new HashSet(catalogFactory.requiredOptions());
        catalogOptions.addAll(catalogFactory.optionalOptions());
        Map contextOptions = context.getOptions();
        HashMap flinkCatalogOptions = new HashMap();
        catalogOptions.forEach(option -> {
            if (contextOptions.containsKey(option.key())) {
                flinkCatalogOptions.put(option.key(), contextOptions.get(option.key()));
            }
        });
        return new FactoryUtil.DefaultCatalogContext(context.getName(), flinkCatalogOptions, context.getConfiguration(), context.getClassLoader());
    }

    @VisibleForTesting
    public static FlinkGenericCatalog createCatalog(ClassLoader cl, Map<String, String> optionMap, String name, Catalog flinkCatalog) {
        Options options = Options.fromMap(optionMap);
        options.set(CatalogOptions.METASTORE, "hive");
        FlinkCatalog paimon = new FlinkCatalog(org.apache.paimon.catalog.CatalogFactory.createCatalog(CatalogContext.create(options, new FlinkFileIOLoader()), cl), name, options.get(FlinkCatalogOptions.DEFAULT_DATABASE), cl, options);
        return new FlinkGenericCatalog(paimon, flinkCatalog);
    }

    private static CatalogFactory createHiveCatalogFactory(ClassLoader cl) {
        return (CatalogFactory)FactoryUtil.discoverFactory((ClassLoader)cl, CatalogFactory.class, (String)"hive");
    }
}

