/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.clone;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.FlinkCatalogFactory;
import org.apache.paimon.options.Options;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloneSourceBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(CloneSourceBuilder.class);
    private final StreamExecutionEnvironment env;
    private final Map<String, String> sourceCatalogConfig;
    private final String database;
    private final String tableName;
    private final String targetDatabase;
    private final String targetTableName;

    public CloneSourceBuilder(StreamExecutionEnvironment env, Map<String, String> sourceCatalogConfig, String database, String tableName, String targetDatabase, String targetTableName) {
        this.env = env;
        this.sourceCatalogConfig = sourceCatalogConfig;
        this.database = database;
        this.tableName = tableName;
        this.targetDatabase = targetDatabase;
        this.targetTableName = targetTableName;
    }

    public DataStream<Tuple2<String, String>> build() throws Exception {
        try (Catalog sourceCatalog = FlinkCatalogFactory.createPaimonCatalog(Options.fromMap(this.sourceCatalogConfig));){
            DataStream<Tuple2<String, String>> dataStream = this.build(sourceCatalog);
            return dataStream;
        }
    }

    private DataStream<Tuple2<String, String>> build(Catalog sourceCatalog) throws Exception {
        ArrayList<Tuple2> result = new ArrayList<Tuple2>();
        if (StringUtils.isBlank(this.database)) {
            Preconditions.checkArgument(StringUtils.isBlank(this.tableName), "tableName must be blank when database is null.");
            Preconditions.checkArgument(StringUtils.isBlank(this.targetDatabase), "targetDatabase must be blank when clone all tables in a catalog.");
            Preconditions.checkArgument(StringUtils.isBlank(this.targetTableName), "targetTableName must be blank when clone all tables in a catalog.");
            for (String db : sourceCatalog.listDatabases()) {
                for (String table : sourceCatalog.listTables(db)) {
                    String s = db + "." + table;
                    result.add(new Tuple2((Object)s, (Object)s));
                }
            }
        } else if (StringUtils.isBlank(this.tableName)) {
            Preconditions.checkArgument(!StringUtils.isBlank(this.targetDatabase), "targetDatabase must not be blank when clone all tables in a database.");
            Preconditions.checkArgument(StringUtils.isBlank(this.targetTableName), "targetTableName must be blank when clone all tables in a catalog.");
            for (String table : sourceCatalog.listTables(this.database)) {
                result.add(new Tuple2((Object)(this.database + "." + table), (Object)(this.targetDatabase + "." + table)));
            }
        } else {
            Preconditions.checkArgument(!StringUtils.isBlank(this.targetDatabase), "targetDatabase must not be blank when clone a table.");
            Preconditions.checkArgument(!StringUtils.isBlank(this.targetTableName), "targetTableName must not be blank when clone a table.");
            result.add(new Tuple2((Object)(this.database + "." + this.tableName), (Object)(this.targetDatabase + "." + this.targetTableName)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("The clone identifiers of source table and target table are: {}", result);
        }
        return this.env.fromCollection(result).forceNonParallel().forward();
    }
}

