/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.types.Row;
import org.apache.paimon.Snapshot;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.SnapshotNotExistException;
import org.apache.paimon.utils.TimeUtils;

public class CreateTagFromTimestampProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "create_tag_from_timestamp";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tag", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="timestamp", type=@DataTypeHint(value="bigint")), @ArgumentHint(name="time_retained", type=@DataTypeHint(value="STRING"), isOptional=true)})
    @DataTypeHint(value="ROW< tagName STRING, snapshot BIGINT, `commit_time` BIGINT, `watermark` STRING>")
    public Row[] call(ProcedureContext procedureContext, String tableId, String tagName, Long timestamp, @Nullable String timeRetained) throws Catalog.TableNotExistException {
        FileStoreTable fileStoreTable = (FileStoreTable)this.table(tableId);
        SnapshotManager snapshotManager = fileStoreTable.snapshotManager();
        Snapshot snapshot = snapshotManager.laterOrEqualTimeMills(timestamp);
        Set<Snapshot> sortedTagsSnapshots = fileStoreTable.tagManager().tags().keySet();
        for (Snapshot tagSnapshot : sortedTagsSnapshots) {
            if (timestamp > tagSnapshot.timeMillis()) continue;
            if (snapshot != null && tagSnapshot.timeMillis() >= snapshot.timeMillis()) break;
            snapshot = tagSnapshot;
            break;
        }
        SnapshotNotExistException.checkNotNull(snapshot, String.format("Could not find any snapshot whose commit-time later than %s.", timestamp));
        fileStoreTable.createTag(tagName, snapshot.id(), CreateTagFromTimestampProcedure.toDuration(timeRetained));
        return new Row[]{Row.of((Object[])new Object[]{tagName, snapshot.id(), snapshot.timeMillis(), String.valueOf(snapshot.watermark())})};
    }

    @Nullable
    private static Duration toDuration(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return TimeUtils.parseDuration(s);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

