/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.time.Duration;
import javax.annotation.Nullable;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.TimeUtils;

public class CreateTagProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "create_tag";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="tag", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="snapshot_id", type=@DataTypeHint(value="BIGINT"), isOptional=true), @ArgumentHint(name="time_retained", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String tagName, @Nullable Long snapshotId, @Nullable String timeRetained) throws Catalog.TableNotExistException {
        Table table = this.catalog.getTable(Identifier.fromString(tableId));
        if (snapshotId == null) {
            table.createTag(tagName, CreateTagProcedure.toDuration(timeRetained));
        } else {
            table.createTag(tagName, snapshotId, CreateTagProcedure.toDuration(timeRetained));
        }
        return new String[]{"Success"};
    }

    @Nullable
    private static Duration toDuration(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return TimeUtils.parseDuration(s);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

