/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.List;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.utils.StringUtils;

public class RemoveOrphanFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_orphan_files";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="older_than", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="dry_run", type=@DataTypeHint(value="BOOLEAN"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String nullableOlderThan, Boolean dryRun) throws Exception {
        String olderThan = this.notnull(nullableOlderThan);
        if (dryRun == null) {
            dryRun = false;
        }
        Identifier identifier = Identifier.fromString(tableId);
        String databaseName = identifier.getDatabaseName();
        String tableName = identifier.getObjectName();
        List<OrphanFilesClean> tableCleans = OrphanFilesClean.createOrphanFilesCleans(this.catalog, databaseName, tableName);
        if (!StringUtils.isBlank(olderThan)) {
            tableCleans.forEach(clean -> clean.olderThan(olderThan));
        }
        if (dryRun.booleanValue()) {
            tableCleans.forEach(clean -> clean.fileCleaner(path -> {}));
        }
        return OrphanFilesClean.executeOrphanFilesClean(tableCleans);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

