/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.StringUtils;

public class RepairProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "repair";

    @Override
    public String identifier() {
        return IDENTIFIER;
    }

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String identifier) throws Catalog.DatabaseNotExistException, Catalog.TableNotExistException {
        if (StringUtils.isBlank(identifier)) {
            this.catalog.repairCatalog();
            return new String[]{"Success"};
        }
        this.repairDatabasesOrTables(identifier);
        return new String[]{"Success"};
    }

    public void repairDatabasesOrTables(String databaseOrTables) throws Catalog.TableNotExistException {
        String[] databaseOrTableSplits;
        block4: for (String split : databaseOrTableSplits = databaseOrTables.split(",")) {
            String[] paths = split.split("\\.");
            switch (paths.length) {
                case 1: {
                    this.catalog.repairDatabase(paths[0]);
                    continue block4;
                }
                case 2: {
                    this.catalog.repairTable(Identifier.create(paths[0], paths[1]));
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Cannot get splits from '%s' to get database and table", split));
                }
            }
        }
    }
}

