/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.compact.UnawareBucketCompactor;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.MultiTableCommittable;
import org.apache.paimon.flink.sink.PrepareCommitOperator;
import org.apache.paimon.options.Options;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.ExceptionUtils;
import org.apache.paimon.utils.ExecutorThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppendOnlyMultiTableCompactionWorkerOperator
extends PrepareCommitOperator<MultiTableUnawareAppendCompactionTask, MultiTableCommittable> {
    private static final Logger LOG = LoggerFactory.getLogger(AppendOnlyMultiTableCompactionWorkerOperator.class);
    private final String commitUser;
    private final Catalog.Loader catalogLoader;
    private transient Map<Identifier, UnawareBucketCompactor> compactorContainer;
    private transient ExecutorService lazyCompactExecutor;
    private transient Catalog catalog;

    public AppendOnlyMultiTableCompactionWorkerOperator(Catalog.Loader catalogLoader, String commitUser, Options options) {
        super(options);
        this.commitUser = commitUser;
        this.catalogLoader = catalogLoader;
    }

    public void open() throws Exception {
        LOG.debug("Opened a append-only multi table compaction worker.");
        this.compactorContainer = new HashMap<Identifier, UnawareBucketCompactor>();
        this.catalog = this.catalogLoader.load();
    }

    @Override
    protected List<MultiTableCommittable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<MultiTableCommittable> result = new ArrayList<MultiTableCommittable>();
        for (Map.Entry<Identifier, UnawareBucketCompactor> compactorWithTable : this.compactorContainer.entrySet()) {
            Identifier tableId = compactorWithTable.getKey();
            UnawareBucketCompactor compactor = compactorWithTable.getValue();
            for (Committable committable : compactor.prepareCommit(waitCompaction, checkpointId)) {
                result.add(new MultiTableCommittable(tableId.getDatabaseName(), tableId.getObjectName(), committable.checkpointId(), committable.kind(), committable.wrappedCommittable()));
            }
        }
        return result;
    }

    public void processElement(StreamRecord<MultiTableUnawareAppendCompactionTask> element) throws Exception {
        Identifier identifier = ((MultiTableUnawareAppendCompactionTask)element.getValue()).tableIdentifier();
        this.compactorContainer.computeIfAbsent(identifier, this::compactor).processElement((UnawareAppendCompactionTask)element.getValue());
    }

    private UnawareBucketCompactor compactor(Identifier tableId) {
        try {
            return new UnawareBucketCompactor((FileStoreTable)this.catalog.getTable(tableId), this.commitUser, this::workerExecutor);
        }
        catch (Catalog.TableNotExistException e) {
            throw new RuntimeException(e);
        }
    }

    private ExecutorService workerExecutor() {
        if (this.lazyCompactExecutor == null) {
            this.lazyCompactExecutor = Executors.newSingleThreadScheduledExecutor(new ExecutorThreadFactory(Thread.currentThread().getName() + "-append-only-compact-worker"));
        }
        return this.lazyCompactExecutor;
    }

    @Override
    public void close() throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        if (this.lazyCompactExecutor != null) {
            try {
                this.lazyCompactExecutor.shutdownNow();
                if (!this.lazyCompactExecutor.awaitTermination(120L, TimeUnit.SECONDS)) {
                    LOG.warn("Executors shutdown timeout, there may be some files that aren't deleted correctly");
                }
            }
            catch (Exception e) {
                LOG.warn(String.format("Fail to stop the compaction executor. Reason: %s, please check the thread stack of append-only-compact-worker.", e.getMessage()), (Throwable)e);
                exceptions.add(e);
            }
            for (Map.Entry<Identifier, UnawareBucketCompactor> compactorEntry : this.compactorContainer.entrySet()) {
                try {
                    UnawareBucketCompactor compactor = compactorEntry.getValue();
                    compactor.close();
                }
                catch (Exception e) {
                    Identifier id = compactorEntry.getKey();
                    LOG.warn(String.format("Fail to roll back the compactor of %s. Reason: %s", id, e.getMessage()), (Throwable)e);
                    exceptions.add(e);
                }
            }
        }
        if (this.catalog != null) {
            this.catalog.close();
            this.catalog = null;
        }
        ExceptionUtils.throwMultiException(exceptions);
    }
}

