/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.OperatorStateStore;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.Options;
import org.apache.paimon.partition.PartitionTimeExtractor;
import org.apache.paimon.utils.PartitionPathUtils;
import org.apache.paimon.utils.StringUtils;

public class PartitionMarkDoneTrigger {
    private static final ListStateDescriptor<List<String>> PENDING_PARTITIONS_STATE_DESC = new ListStateDescriptor("mark-done-pending-partitions", (TypeSerializer)new ListSerializer((TypeSerializer)StringSerializer.INSTANCE));
    private final State state;
    private final PartitionTimeExtractor timeExtractor;
    @Nullable
    private final Long timeInterval;
    @Nullable
    private final Long idleTime;
    private final boolean markDoneWhenEndInput;
    private final Map<String, Long> pendingPartitions = new HashMap<String, Long>();

    public PartitionMarkDoneTrigger(State state, PartitionTimeExtractor timeExtractor, @Nullable Duration timeInterval, @Nullable Duration idleTime, boolean markDoneWhenEndInput) throws Exception {
        this(state, timeExtractor, timeInterval, idleTime, System.currentTimeMillis(), markDoneWhenEndInput);
    }

    public PartitionMarkDoneTrigger(State state, PartitionTimeExtractor timeExtractor, @Nullable Duration timeInterval, @Nullable Duration idleTime, long currentTimeMillis, boolean markDoneWhenEndInput) throws Exception {
        this.state = state;
        this.timeExtractor = timeExtractor;
        this.timeInterval = timeInterval == null ? null : Long.valueOf(timeInterval.toMillis());
        this.idleTime = idleTime == null ? null : Long.valueOf(idleTime.toMillis());
        this.markDoneWhenEndInput = markDoneWhenEndInput;
        state.restore().forEach(p -> this.pendingPartitions.put((String)p, currentTimeMillis));
    }

    public void notifyPartition(String partition) {
        this.notifyPartition(partition, System.currentTimeMillis());
    }

    @VisibleForTesting
    void notifyPartition(String partition, long currentTimeMillis) {
        if (!StringUtils.isNullOrWhitespaceOnly(partition)) {
            this.pendingPartitions.put(partition, currentTimeMillis);
        }
    }

    public List<String> donePartitions(boolean endInput) {
        return this.donePartitions(endInput, System.currentTimeMillis());
    }

    @VisibleForTesting
    List<String> donePartitions(boolean endInput, long currentTimeMillis) {
        if (endInput && this.markDoneWhenEndInput) {
            return new ArrayList<String>(this.pendingPartitions.keySet());
        }
        if (this.timeInterval == null || this.idleTime == null) {
            return Collections.emptyList();
        }
        ArrayList<String> needDone = new ArrayList<String>();
        Iterator<Map.Entry<String, Long>> iter = this.pendingPartitions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Long> entry = iter.next();
            String partition = entry.getKey();
            long lastUpdateTime = entry.getValue();
            long partitionStartTime = this.extractDateTime(partition).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            long partitionEndTime = partitionStartTime + this.timeInterval;
            if (currentTimeMillis - (lastUpdateTime = Math.max(lastUpdateTime, partitionEndTime)) <= this.idleTime) continue;
            needDone.add(partition);
            iter.remove();
        }
        return needDone;
    }

    @VisibleForTesting
    LocalDateTime extractDateTime(String partition) {
        try {
            return this.timeExtractor.extract(PartitionPathUtils.extractPartitionSpecFromPath(new Path(partition)));
        }
        catch (DateTimeParseException e) {
            throw new RuntimeException("Can't extract datetime from partition " + partition, e);
        }
    }

    public void snapshotState() throws Exception {
        this.state.update(new ArrayList<String>(this.pendingPartitions.keySet()));
    }

    public static PartitionMarkDoneTrigger create(CoreOptions coreOptions, boolean isRestored, OperatorStateStore stateStore) throws Exception {
        Options options = coreOptions.toConfiguration();
        return new PartitionMarkDoneTrigger(new PartitionMarkDoneTriggerState(isRestored, stateStore), new PartitionTimeExtractor(coreOptions.partitionTimestampPattern(), coreOptions.partitionTimestampFormatter()), options.get(FlinkConnectorOptions.PARTITION_TIME_INTERVAL), options.get(FlinkConnectorOptions.PARTITION_IDLE_TIME_TO_DONE), options.get(FlinkConnectorOptions.PARTITION_MARK_DONE_WHEN_END_INPUT));
    }

    private static class PartitionMarkDoneTriggerState
    implements State {
        private final boolean isRestored;
        private final ListState<List<String>> pendingPartitionsState;

        public PartitionMarkDoneTriggerState(boolean isRestored, OperatorStateStore stateStore) throws Exception {
            this.isRestored = isRestored;
            this.pendingPartitionsState = stateStore.getListState(PENDING_PARTITIONS_STATE_DESC);
        }

        @Override
        public List<String> restore() throws Exception {
            ArrayList<String> pendingPartitions = new ArrayList<String>();
            if (this.isRestored) {
                pendingPartitions.addAll((Collection)((Iterable)this.pendingPartitionsState.get()).iterator().next());
            }
            return pendingPartitions;
        }

        @Override
        public void update(List<String> partitions) throws Exception {
            this.pendingPartitionsState.update(Collections.singletonList(partitions));
        }
    }

    public static interface State {
        public List<String> restore() throws Exception;

        public void update(List<String> var1) throws Exception;
    }
}

