/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.Path;
import org.apache.paimon.io.DataFilePathFactory;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.stats.SimpleStats;
import org.apache.paimon.types.ArrayType;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TinyIntType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

@Public
public class DataFileMeta {
    public static final RowType SCHEMA = new RowType(false, Arrays.asList(new DataField(0, "_FILE_NAME", SerializationUtils.newStringType(false)), new DataField(1, "_FILE_SIZE", new BigIntType(false)), new DataField(2, "_ROW_COUNT", new BigIntType(false)), new DataField(3, "_MIN_KEY", SerializationUtils.newBytesType(false)), new DataField(4, "_MAX_KEY", SerializationUtils.newBytesType(false)), new DataField(5, "_KEY_STATS", SimpleStats.SCHEMA), new DataField(6, "_VALUE_STATS", SimpleStats.SCHEMA), new DataField(7, "_MIN_SEQUENCE_NUMBER", new BigIntType(false)), new DataField(8, "_MAX_SEQUENCE_NUMBER", new BigIntType(false)), new DataField(9, "_SCHEMA_ID", new BigIntType(false)), new DataField(10, "_LEVEL", new IntType(false)), new DataField(11, "_EXTRA_FILES", new ArrayType(false, SerializationUtils.newStringType(false))), new DataField(12, "_CREATION_TIME", DataTypes.TIMESTAMP_MILLIS()), new DataField(13, "_DELETE_ROW_COUNT", new BigIntType(true)), new DataField(14, "_EMBEDDED_FILE_INDEX", SerializationUtils.newBytesType(true)), new DataField(15, "_FILE_SOURCE", new TinyIntType(true))));
    public static final BinaryRow EMPTY_MIN_KEY = BinaryRow.EMPTY_ROW;
    public static final BinaryRow EMPTY_MAX_KEY = BinaryRow.EMPTY_ROW;
    public static final int DUMMY_LEVEL = 0;
    private final String fileName;
    private final long fileSize;
    private final long rowCount;
    private final BinaryRow minKey;
    private final BinaryRow maxKey;
    private final SimpleStats keyStats;
    private final SimpleStats valueStats;
    private final long minSequenceNumber;
    private final long maxSequenceNumber;
    private final long schemaId;
    private final int level;
    private final List<String> extraFiles;
    private final Timestamp creationTime;
    @Nullable
    private final Long deleteRowCount;
    @Nullable
    private final byte[] embeddedIndex;
    @Nullable
    private final FileSource fileSource;

    public static DataFileMeta forAppend(String fileName, long fileSize, long rowCount, SimpleStats rowStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, @Nullable FileSource fileSource) {
        return DataFileMeta.forAppend(fileName, fileSize, rowCount, rowStats, minSequenceNumber, maxSequenceNumber, schemaId, Collections.emptyList(), null, fileSource);
    }

    public static DataFileMeta forAppend(String fileName, long fileSize, long rowCount, SimpleStats rowStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, List<String> extraFiles, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource) {
        return new DataFileMeta(fileName, fileSize, rowCount, EMPTY_MIN_KEY, EMPTY_MAX_KEY, SimpleStats.EMPTY_STATS, rowStats, minSequenceNumber, maxSequenceNumber, schemaId, 0, extraFiles, Timestamp.fromLocalDateTime(LocalDateTime.now()).toMillisTimestamp(), 0L, embeddedIndex, fileSource);
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource) {
        this(fileName, fileSize, rowCount, minKey, maxKey, keyStats, valueStats, minSequenceNumber, maxSequenceNumber, schemaId, level, Collections.emptyList(), Timestamp.fromLocalDateTime(LocalDateTime.now()).toMillisTimestamp(), deleteRowCount, embeddedIndex, fileSource);
    }

    public DataFileMeta(String fileName, long fileSize, long rowCount, BinaryRow minKey, BinaryRow maxKey, SimpleStats keyStats, SimpleStats valueStats, long minSequenceNumber, long maxSequenceNumber, long schemaId, int level, List<String> extraFiles, Timestamp creationTime, @Nullable Long deleteRowCount, @Nullable byte[] embeddedIndex, @Nullable FileSource fileSource) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.rowCount = rowCount;
        this.embeddedIndex = embeddedIndex;
        this.minKey = minKey;
        this.maxKey = maxKey;
        this.keyStats = keyStats;
        this.valueStats = valueStats;
        this.minSequenceNumber = minSequenceNumber;
        this.maxSequenceNumber = maxSequenceNumber;
        this.level = level;
        this.schemaId = schemaId;
        this.extraFiles = Collections.unmodifiableList(extraFiles);
        this.creationTime = creationTime;
        this.deleteRowCount = deleteRowCount;
        this.fileSource = fileSource;
    }

    public String fileName() {
        return this.fileName;
    }

    public long fileSize() {
        return this.fileSize;
    }

    public long rowCount() {
        return this.rowCount;
    }

    public Optional<Long> addRowCount() {
        return Optional.ofNullable(this.deleteRowCount).map(c -> this.rowCount - c);
    }

    public Optional<Long> deleteRowCount() {
        return Optional.ofNullable(this.deleteRowCount);
    }

    public byte[] embeddedIndex() {
        return this.embeddedIndex;
    }

    public BinaryRow minKey() {
        return this.minKey;
    }

    public BinaryRow maxKey() {
        return this.maxKey;
    }

    public SimpleStats keyStats() {
        return this.keyStats;
    }

    public SimpleStats valueStats() {
        return this.valueStats;
    }

    public long minSequenceNumber() {
        return this.minSequenceNumber;
    }

    public long maxSequenceNumber() {
        return this.maxSequenceNumber;
    }

    public long schemaId() {
        return this.schemaId;
    }

    public int level() {
        return this.level;
    }

    public List<String> extraFiles() {
        return this.extraFiles;
    }

    public Timestamp creationTime() {
        return this.creationTime;
    }

    public long creationTimeEpochMillis() {
        return this.creationTime.toLocalDateTime().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    public String fileFormat() {
        String[] split = this.fileName.split("\\.");
        if (split.length == 1) {
            throw new RuntimeException("Can't find format from file: " + this.fileName());
        }
        return split[split.length - 1];
    }

    public Optional<FileSource> fileSource() {
        return Optional.ofNullable(this.fileSource);
    }

    public DataFileMeta upgrade(int newLevel) {
        Preconditions.checkArgument(newLevel > this.level);
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, newLevel, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource);
    }

    public DataFileMeta rename(String newFileName) {
        return new DataFileMeta(newFileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource);
    }

    public List<Path> collectFiles(DataFilePathFactory pathFactory) {
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(pathFactory.toPath(this.fileName));
        this.extraFiles.forEach(f -> paths.add(pathFactory.toPath((String)f)));
        return paths;
    }

    public DataFileMeta copy(List<String> newExtraFiles) {
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, newExtraFiles, this.creationTime, this.deleteRowCount, this.embeddedIndex, this.fileSource);
    }

    public DataFileMeta copy(byte[] newEmbeddedIndex) {
        return new DataFileMeta(this.fileName, this.fileSize, this.rowCount, this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, newEmbeddedIndex, this.fileSource);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataFileMeta)) {
            return false;
        }
        DataFileMeta that = (DataFileMeta)o;
        return Objects.equals(this.fileName, that.fileName) && this.fileSize == that.fileSize && this.rowCount == that.rowCount && Arrays.equals(this.embeddedIndex, that.embeddedIndex) && Objects.equals(this.minKey, that.minKey) && Objects.equals(this.maxKey, that.maxKey) && Objects.equals(this.keyStats, that.keyStats) && Objects.equals(this.valueStats, that.valueStats) && this.minSequenceNumber == that.minSequenceNumber && this.maxSequenceNumber == that.maxSequenceNumber && this.schemaId == that.schemaId && this.level == that.level && Objects.equals(this.extraFiles, that.extraFiles) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.deleteRowCount, that.deleteRowCount) && Objects.equals((Object)this.fileSource, (Object)that.fileSource);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileName, this.fileSize, this.rowCount, Arrays.hashCode(this.embeddedIndex), this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.fileSource});
    }

    public String toString() {
        return String.format("{fileName: %s, fileSize: %d, rowCount: %d, embeddedIndex: %s, minKey: %s, maxKey: %s, keyStats: %s, valueStats: %s, minSequenceNumber: %d, maxSequenceNumber: %d, schemaId: %d, level: %d, extraFiles: %s, creationTime: %s, deleteRowCount: %d, fileSource: %s}", new Object[]{this.fileName, this.fileSize, this.rowCount, Arrays.toString(this.embeddedIndex), this.minKey, this.maxKey, this.keyStats, this.valueStats, this.minSequenceNumber, this.maxSequenceNumber, this.schemaId, this.level, this.extraFiles, this.creationTime, this.deleteRowCount, this.fileSource});
    }

    public static long getMaxSequenceNumber(List<DataFileMeta> fileMetas) {
        return fileMetas.stream().map(DataFileMeta::maxSequenceNumber).max(Long::compare).orElse(-1L);
    }
}

