/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation.metrics;

import org.apache.paimon.annotation.VisibleForTesting;

public class ScanStats {
    private final long duration;
    private final long scannedManifests;
    private final long skippedByPartitionAndStats;
    private final long skippedByBucketAndLevelFilter;
    private final long skippedByWholeBucketFiles;
    private final long skippedTableFiles;
    private final long resultedTableFiles;

    public ScanStats(long duration, long scannedManifests, long skippedByPartitionAndStats, long skippedByBucketAndLevelFilter, long skippedByWholeBucketFiles, long resultedTableFiles) {
        this.duration = duration;
        this.scannedManifests = scannedManifests;
        this.skippedByPartitionAndStats = skippedByPartitionAndStats;
        this.skippedByBucketAndLevelFilter = skippedByBucketAndLevelFilter;
        this.skippedByWholeBucketFiles = skippedByWholeBucketFiles;
        this.skippedTableFiles = skippedByPartitionAndStats + skippedByBucketAndLevelFilter + skippedByWholeBucketFiles;
        this.resultedTableFiles = resultedTableFiles;
    }

    @VisibleForTesting
    protected long getScannedManifests() {
        return this.scannedManifests;
    }

    @VisibleForTesting
    protected long getSkippedTableFiles() {
        return this.skippedTableFiles;
    }

    @VisibleForTesting
    protected long getResultedTableFiles() {
        return this.resultedTableFiles;
    }

    @VisibleForTesting
    protected long getSkippedByPartitionAndStats() {
        return this.skippedByPartitionAndStats;
    }

    @VisibleForTesting
    protected long getSkippedByBucketAndLevelFilter() {
        return this.skippedByBucketAndLevelFilter;
    }

    @VisibleForTesting
    protected long getSkippedByWholeBucketFiles() {
        return this.skippedByWholeBucketFiles;
    }

    @VisibleForTesting
    protected long getDuration() {
        return this.duration;
    }
}

