/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.privilege;

import java.util.List;
import java.util.Map;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.DelegateCatalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.privilege.FileBasedPrivilegeManager;
import org.apache.paimon.privilege.PrivilegeManager;
import org.apache.paimon.privilege.PrivilegeType;
import org.apache.paimon.privilege.PrivilegedFileStoreTable;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaChange;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;

public class PrivilegedCatalog
extends DelegateCatalog {
    public static final ConfigOption<String> USER = ConfigOptions.key("user").stringType().defaultValue("anonymous");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key("password").stringType().defaultValue("anonymous");
    private final PrivilegeManager privilegeManager;

    public PrivilegedCatalog(Catalog wrapped, PrivilegeManager privilegeManager) {
        super(wrapped);
        this.privilegeManager = privilegeManager;
    }

    public static Catalog tryToCreate(Catalog catalog, Options options) {
        FileBasedPrivilegeManager privilegeManager = new FileBasedPrivilegeManager(catalog.warehouse(), catalog.fileIO(), options.get(USER), options.get(PASSWORD));
        if (privilegeManager.privilegeEnabled()) {
            catalog = new PrivilegedCatalog(catalog, privilegeManager);
        }
        return catalog;
    }

    public PrivilegeManager privilegeManager() {
        return this.privilegeManager;
    }

    @Override
    public void createDatabase(String name, boolean ignoreIfExists, Map<String, String> properties) throws Catalog.DatabaseAlreadyExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanCreateDatabase();
        this.wrapped.createDatabase(name, ignoreIfExists, properties);
    }

    @Override
    public void dropDatabase(String name, boolean ignoreIfNotExists, boolean cascade) throws Catalog.DatabaseNotExistException, Catalog.DatabaseNotEmptyException {
        this.privilegeManager.getPrivilegeChecker().assertCanDropDatabase(name);
        this.wrapped.dropDatabase(name, ignoreIfNotExists, cascade);
        this.privilegeManager.objectDropped(name);
    }

    @Override
    public void dropTable(Identifier identifier, boolean ignoreIfNotExists) throws Catalog.TableNotExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanDropTable(identifier);
        this.wrapped.dropTable(identifier, ignoreIfNotExists);
        this.privilegeManager.objectDropped(identifier.getFullName());
    }

    @Override
    public void createTable(Identifier identifier, Schema schema, boolean ignoreIfExists) throws Catalog.TableAlreadyExistException, Catalog.DatabaseNotExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanCreateTable(identifier.getDatabaseName());
        this.wrapped.createTable(identifier, schema, ignoreIfExists);
    }

    @Override
    public void renameTable(Identifier fromTable, Identifier toTable, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.TableAlreadyExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanAlterTable(fromTable);
        this.wrapped.renameTable(fromTable, toTable, ignoreIfNotExists);
        Preconditions.checkState(this.wrapped.tableExists(toTable), "Table " + toTable + " does not exist. There might be concurrent renaming. Aborting updates in privilege system.");
        this.privilegeManager.objectRenamed(fromTable.getFullName(), toTable.getFullName());
    }

    @Override
    public void alterTable(Identifier identifier, List<SchemaChange> changes, boolean ignoreIfNotExists) throws Catalog.TableNotExistException, Catalog.ColumnAlreadyExistException, Catalog.ColumnNotExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanAlterTable(identifier);
        this.wrapped.alterTable(identifier, changes, ignoreIfNotExists);
    }

    @Override
    public Table getTable(Identifier identifier) throws Catalog.TableNotExistException {
        Table table = this.wrapped.getTable(identifier);
        if (table instanceof FileStoreTable) {
            return new PrivilegedFileStoreTable((FileStoreTable)table, this.privilegeManager.getPrivilegeChecker(), identifier);
        }
        return table;
    }

    @Override
    public void dropPartition(Identifier identifier, Map<String, String> partitions) throws Catalog.TableNotExistException, Catalog.PartitionNotExistException {
        this.privilegeManager.getPrivilegeChecker().assertCanInsert(identifier);
        this.wrapped.dropPartition(identifier, partitions);
    }

    public void createPrivilegedUser(String user, String password) {
        this.privilegeManager.createUser(user, password);
    }

    public void dropPrivilegedUser(String user) {
        this.privilegeManager.dropUser(user);
    }

    public void grantPrivilegeOnCatalog(String user, PrivilegeType privilege) {
        Preconditions.checkArgument(privilege.canGrantOnCatalog(), "Privilege " + (Object)((Object)privilege) + " can't be granted on a catalog");
        this.privilegeManager.grant(user, "", privilege);
    }

    public void grantPrivilegeOnDatabase(String user, String databaseName, PrivilegeType privilege) {
        Preconditions.checkArgument(privilege.canGrantOnDatabase(), "Privilege " + (Object)((Object)privilege) + " can't be granted on a database");
        Preconditions.checkArgument(this.databaseExists(databaseName), "Database " + databaseName + " does not exist");
        this.privilegeManager.grant(user, databaseName, privilege);
    }

    public void grantPrivilegeOnTable(String user, Identifier identifier, PrivilegeType privilege) {
        Preconditions.checkArgument(privilege.canGrantOnTable(), "Privilege " + (Object)((Object)privilege) + " can't be granted on a table");
        Preconditions.checkArgument(this.tableExists(identifier), "Table " + identifier + " does not exist");
        this.privilegeManager.grant(user, identifier.getFullName(), privilege);
    }

    public int revokePrivilegeOnCatalog(String user, PrivilegeType privilege) {
        return this.privilegeManager.revoke(user, "", privilege);
    }

    public int revokePrivilegeOnDatabase(String user, String databaseName, PrivilegeType privilege) {
        return this.privilegeManager.revoke(user, databaseName, privilege);
    }

    public int revokePrivilegeOnTable(String user, Identifier identifier, PrivilegeType privilege) {
        return this.privilegeManager.revoke(user, identifier.getFullName(), privilege);
    }
}

