/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data.columnar.heap;

import java.util.Arrays;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.data.columnar.heap.AbstractHeapVector;
import org.apache.paimon.data.columnar.writable.WritableTimestampVector;

public class HeapTimestampVector
extends AbstractHeapVector
implements WritableTimestampVector {
    private static final long serialVersionUID = 1L;
    private final long[] milliseconds;
    private final int[] nanoOfMilliseconds;

    public HeapTimestampVector(int len) {
        super(len);
        this.milliseconds = new long[len];
        this.nanoOfMilliseconds = new int[len];
    }

    @Override
    public Timestamp getTimestamp(int i, int precision) {
        if (this.dictionary == null) {
            return Timestamp.fromEpochMillis(this.milliseconds[i], this.nanoOfMilliseconds[i]);
        }
        return this.dictionary.decodeToTimestamp(this.dictionaryIds.vector[i]);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp) {
        this.milliseconds[i] = timestamp.getMillisecond();
        this.nanoOfMilliseconds[i] = timestamp.getNanoOfMillisecond();
    }

    @Override
    public void fill(Timestamp value) {
        Arrays.fill(this.milliseconds, value.getMillisecond());
        Arrays.fill(this.nanoOfMilliseconds, value.getNanoOfMillisecond());
    }
}

