/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.paimon.append.MultiTableUnawareAppendCompactionTask;
import org.apache.paimon.append.UnawareAppendTableCompactionCoordinator;
import org.apache.paimon.catalog.CatalogLoader;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.compact.MultiTableScanBase;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.table.FileStoreTable;

public class MultiUnawareBucketTableScan
extends MultiTableScanBase<MultiTableUnawareAppendCompactionTask> {
    protected transient Map<Identifier, UnawareAppendTableCompactionCoordinator> tablesMap = new HashMap<Identifier, UnawareAppendTableCompactionCoordinator>();

    public MultiUnawareBucketTableScan(CatalogLoader catalogLoader, Pattern includingPattern, Pattern excludingPattern, Pattern databasePattern, boolean isStreaming) {
        super(catalogLoader, includingPattern, excludingPattern, databasePattern, isStreaming);
    }

    @Override
    List<MultiTableUnawareAppendCompactionTask> doScan() {
        ArrayList<MultiTableUnawareAppendCompactionTask> tasks = new ArrayList<MultiTableUnawareAppendCompactionTask>();
        for (Map.Entry<Identifier, UnawareAppendTableCompactionCoordinator> tableIdAndCoordinator : this.tablesMap.entrySet()) {
            Identifier tableId = tableIdAndCoordinator.getKey();
            UnawareAppendTableCompactionCoordinator compactionCoordinator = tableIdAndCoordinator.getValue();
            compactionCoordinator.run().stream().map(task -> new MultiTableUnawareAppendCompactionTask(task.partition(), task.compactBefore(), tableId)).forEach(tasks::add);
        }
        return tasks;
    }

    @Override
    public boolean checkTableScanned(Identifier identifier) {
        return this.tablesMap.containsKey(identifier);
    }

    @Override
    public void addScanTable(FileStoreTable fileStoreTable, Identifier identifier) {
        if (fileStoreTable.bucketMode() == BucketMode.BUCKET_UNAWARE) {
            this.tablesMap.put(identifier, new UnawareAppendTableCompactionCoordinator(fileStoreTable, this.isStreaming));
        }
    }
}

