/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact.changelog.format;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.flink.compact.changelog.format.CompactedChangelogFormatReaderFactory;
import org.apache.paimon.format.FileFormat;
import org.apache.paimon.format.FileFormatFactory;
import org.apache.paimon.format.FormatReaderFactory;
import org.apache.paimon.format.FormatWriterFactory;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.types.RowType;

public class CompactedChangelogReadOnlyFormat
extends FileFormat {
    private final FileFormat wrapped;

    protected CompactedChangelogReadOnlyFormat(String formatIdentifier, FileFormat wrapped) {
        super(formatIdentifier);
        this.wrapped = wrapped;
    }

    @Override
    public FormatReaderFactory createReaderFactory(RowType projectedRowType, @Nullable List<Predicate> filters) {
        return new CompactedChangelogFormatReaderFactory(this.wrapped.createReaderFactory(projectedRowType, filters));
    }

    @Override
    public FormatWriterFactory createWriterFactory(RowType type) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void validateDataFields(RowType rowType) {
        this.wrapped.validateDataFields(rowType);
    }

    public static String getIdentifier(String wrappedFormat) {
        return "cc-" + wrappedFormat;
    }

    public static class AvroFactory
    extends AbstractFactory {
        public AvroFactory() {
            super("avro");
        }
    }

    public static class ParquetFactory
    extends AbstractFactory {
        public ParquetFactory() {
            super("parquet");
        }
    }

    public static class OrcFactory
    extends AbstractFactory {
        public OrcFactory() {
            super("orc");
        }
    }

    static class AbstractFactory
    implements FileFormatFactory {
        private final String format;

        AbstractFactory(String format) {
            this.format = format;
        }

        @Override
        public String identifier() {
            return CompactedChangelogReadOnlyFormat.getIdentifier(this.format);
        }

        @Override
        public FileFormat create(FileFormatFactory.FormatContext formatContext) {
            return new CompactedChangelogReadOnlyFormat(CompactedChangelogReadOnlyFormat.getIdentifier(this.format), FileFormat.fromIdentifier(this.format, formatContext));
        }
    }
}

