/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.flink.lookup.FullCacheLookupTable;
import org.apache.paimon.flink.lookup.LookupFileStoreTable;
import org.apache.paimon.lookup.BulkLoader;
import org.apache.paimon.lookup.RocksDBValueState;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.KeyProjectedRow;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.TypeUtils;

public class PrimaryKeyLookupTable
extends FullCacheLookupTable {
    protected final long lruCacheSize;
    protected final KeyProjectedRow primaryKeyRow;
    @Nullable
    private final ProjectedRow keyRearrange;
    protected RocksDBValueState<InternalRow, InternalRow> tableState;

    public PrimaryKeyLookupTable(FullCacheLookupTable.Context context, long lruCacheSize, List<String> joinKey) {
        super(context);
        this.lruCacheSize = lruCacheSize;
        List<String> fieldNames = this.projectedType.getFieldNames();
        LookupFileStoreTable table = context.table;
        int[] primaryKeyMapping = table.primaryKeys().stream().mapToInt(fieldNames::indexOf).toArray();
        this.primaryKeyRow = new KeyProjectedRow(primaryKeyMapping);
        ProjectedRow keyRearrange = null;
        if (!table.primaryKeys().equals(joinKey)) {
            keyRearrange = ProjectedRow.from(table.primaryKeys().stream().map(joinKey::indexOf).mapToInt(value -> value).toArray());
        }
        this.keyRearrange = keyRearrange;
    }

    @Override
    public void open() throws Exception {
        this.openStateFactory();
        this.createTableState();
        this.bootstrap();
    }

    protected void createTableState() throws IOException {
        this.tableState = this.stateFactory.valueState("table", InternalSerializers.create(TypeUtils.project(this.projectedType, this.primaryKeyRow.indexMapping())), InternalSerializers.create(this.projectedType), this.lruCacheSize);
    }

    @Override
    public List<InternalRow> innerGet(InternalRow key) throws IOException {
        InternalRow value;
        if (this.keyRearrange != null) {
            key = this.keyRearrange.replaceRow(key);
        }
        return (value = this.tableState.get(key)) == null ? Collections.emptyList() : Collections.singletonList(value);
    }

    @Override
    protected void refreshRow(InternalRow row, Predicate predicate) throws IOException {
        InternalRow previous;
        this.primaryKeyRow.replaceRow(row);
        if (this.userDefinedSeqComparator != null && (previous = this.tableState.get(this.primaryKeyRow)) != null && this.userDefinedSeqComparator.compare(previous, row) > 0) {
            return;
        }
        if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
            if (predicate == null || predicate.test(row)) {
                this.tableState.put(this.primaryKeyRow, row);
            } else {
                this.tableState.delete(this.primaryKeyRow);
            }
        } else {
            this.tableState.delete(this.primaryKeyRow);
        }
    }

    @Override
    public byte[] toKeyBytes(InternalRow row) throws IOException {
        this.primaryKeyRow.replaceRow(row);
        return this.tableState.serializeKey(this.primaryKeyRow);
    }

    @Override
    public byte[] toValueBytes(InternalRow row) throws IOException {
        return this.tableState.serializeValue(row);
    }

    @Override
    public FullCacheLookupTable.TableBulkLoader createBulkLoader() {
        final BulkLoader bulkLoader = this.tableState.createBulkLoader();
        return new FullCacheLookupTable.TableBulkLoader(){

            @Override
            public void write(byte[] key, byte[] value) throws BulkLoader.WriteException, IOException {
                bulkLoader.write(key, value);
                PrimaryKeyLookupTable.this.bulkLoadWritePlus(key, value);
            }

            @Override
            public void finish() {
                bulkLoader.finish();
            }
        };
    }

    public void bulkLoadWritePlus(byte[] key, byte[] value) throws IOException {
    }
}

