/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.flink.utils.TableMigrationUtils;
import org.apache.paimon.migrate.Migrator;

public class MigrateFileProcedure
extends ProcedureBase {
    @Override
    public String identifier() {
        return "migrate_file";
    }

    @ProcedureHint(argument={@ArgumentHint(name="connector", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="source_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="target_table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="delete_origin", type=@DataTypeHint(value="BOOLEAN"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="Integer"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String connector, String sourceTablePath, String targetPaimonTablePath, Boolean deleteOrigin, Integer parallelism) throws Exception {
        if (deleteOrigin == null) {
            deleteOrigin = true;
        }
        Integer p = parallelism == null ? Runtime.getRuntime().availableProcessors() : parallelism.intValue();
        this.migrateHandle(connector, sourceTablePath, targetPaimonTablePath, deleteOrigin, p);
        return new String[]{"Success"};
    }

    public void migrateHandle(String connector, String sourceTablePath, String targetPaimonTablePath, boolean deleteOrigin, Integer parallelism) throws Exception {
        Identifier sourceTableId = Identifier.fromString(sourceTablePath);
        Identifier targetTableId = Identifier.fromString(targetPaimonTablePath);
        try {
            this.catalog.getTable(targetTableId);
        }
        catch (Catalog.TableNotExistException e) {
            throw new IllegalArgumentException("Target paimon table does not exist: " + targetPaimonTablePath);
        }
        Migrator importer = TableMigrationUtils.getImporter(connector, this.catalog, sourceTableId.getDatabaseName(), sourceTableId.getObjectName(), targetTableId.getDatabaseName(), targetTableId.getObjectName(), parallelism, Collections.emptyMap());
        importer.deleteOriginTable(deleteOrigin);
        importer.executeMigrate();
    }
}

