/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.functions.FilterFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.FlinkConnectorOptions;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.source.ContinuousFileStoreSource;
import org.apache.paimon.flink.source.StaticFileStoreSource;
import org.apache.paimon.manifest.PartitionEntry;
import org.apache.paimon.options.Options;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.ReadBuilder;
import org.apache.paimon.table.system.CompactBucketsTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SerializationUtils;

public class CompactorSourceBuilder {
    private final String tableIdentifier;
    private final FileStoreTable table;
    private boolean isContinuous = false;
    private StreamExecutionEnvironment env;
    @Nullable
    private Predicate partitionPredicate = null;
    @Nullable
    private Duration partitionIdleTime = null;

    public CompactorSourceBuilder(String tableIdentifier, FileStoreTable table) {
        this.tableIdentifier = tableIdentifier;
        this.table = table;
    }

    public CompactorSourceBuilder withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
        return this;
    }

    public CompactorSourceBuilder withEnv(StreamExecutionEnvironment env) {
        this.env = env;
        return this;
    }

    public CompactorSourceBuilder withPartitionIdleTime(@Nullable Duration partitionIdleTime) {
        this.partitionIdleTime = partitionIdleTime;
        return this;
    }

    private Source<RowData, ?, ?> buildSource(CompactBucketsTable compactBucketsTable) {
        if (this.isContinuous) {
            compactBucketsTable = ((CompactBucketsTable)compactBucketsTable).copy((Map)this.streamingCompactOptions());
            return new ContinuousFileStoreSource(compactBucketsTable.newReadBuilder().withFilter(this.partitionPredicate), ((CompactBucketsTable)compactBucketsTable).options(), null);
        }
        compactBucketsTable = ((CompactBucketsTable)compactBucketsTable).copy((Map)this.batchCompactOptions());
        ReadBuilder readBuilder = compactBucketsTable.newReadBuilder().withFilter(this.partitionPredicate);
        Options options = ((CompactBucketsTable)compactBucketsTable).coreOptions().toConfiguration();
        return new StaticFileStoreSource(readBuilder, null, options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_BATCH_SIZE), options.get(FlinkConnectorOptions.SCAN_SPLIT_ENUMERATOR_ASSIGN_MODE));
    }

    public DataStreamSource<RowData> build() {
        if (this.env == null) {
            throw new IllegalArgumentException("StreamExecutionEnvironment should not be null.");
        }
        CompactBucketsTable compactBucketsTable = new CompactBucketsTable(this.table, this.isContinuous);
        RowType produceType = compactBucketsTable.rowType();
        DataStreamSource dataStream = this.env.fromSource(this.buildSource(compactBucketsTable), WatermarkStrategy.noWatermarks(), this.tableIdentifier + "-compact-source", (TypeInformation)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)));
        if (this.isContinuous) {
            Preconditions.checkArgument(this.partitionIdleTime == null, "Streaming mode does not support partitionIdleTime");
        } else if (this.partitionIdleTime != null) {
            Map<BinaryRow, Long> partitionInfo = this.getPartitionInfo(compactBucketsTable);
            long historyMilli = LocalDateTime.now().minus(this.partitionIdleTime).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            SingleOutputStreamOperator filterStream = dataStream.filter((FilterFunction & Serializable)rowData -> {
                BinaryRow partition = SerializationUtils.deserializeBinaryRow(rowData.getBinary(1));
                return (Long)partitionInfo.get(partition) <= historyMilli;
            });
            dataStream = new DataStreamSource(filterStream);
        }
        Integer parallelism = Options.fromMap(this.table.options()).get(FlinkConnectorOptions.SCAN_PARALLELISM);
        if (parallelism != null) {
            dataStream.setParallelism(parallelism.intValue());
        }
        return dataStream;
    }

    private Map<String, String> streamingCompactOptions() {
        return new HashMap<String, String>(){
            {
                this.put(CoreOptions.STREAM_SCAN_MODE.key(), CoreOptions.StreamScanMode.COMPACT_BUCKET_TABLE.getValue());
                this.put(CoreOptions.SCAN_BOUNDED_WATERMARK.key(), null);
            }
        };
    }

    private Map<String, String> batchCompactOptions() {
        return new HashMap<String, String>(){
            {
                this.put(CoreOptions.SCAN_TIMESTAMP_MILLIS.key(), null);
                this.put(CoreOptions.SCAN_FILE_CREATION_TIME_MILLIS.key(), null);
                this.put(CoreOptions.SCAN_TIMESTAMP.key(), null);
                this.put(CoreOptions.SCAN_SNAPSHOT_ID.key(), null);
                this.put(CoreOptions.SCAN_MODE.key(), CoreOptions.StartupMode.LATEST_FULL.toString());
            }
        };
    }

    public CompactorSourceBuilder withPartitionPredicate(@Nullable Predicate partitionPredicate) {
        this.partitionPredicate = partitionPredicate;
        return this;
    }

    private Map<BinaryRow, Long> getPartitionInfo(CompactBucketsTable table) {
        List<PartitionEntry> partitions = table.newSnapshotReader().partitionEntries();
        return partitions.stream().collect(Collectors.toMap(PartitionEntry::partition, PartitionEntry::lastFileCreationTime));
    }
}

