/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.manifest.ManifestEntrySerializer;
import org.apache.paimon.manifest.ManifestFile;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Filter;
import org.apache.paimon.utils.ManifestReadThreadPool;
import org.apache.paimon.utils.Preconditions;

public interface FileEntry {
    public FileKind kind();

    public BinaryRow partition();

    public int bucket();

    public int level();

    public String fileName();

    @Nullable
    public String externalPath();

    public Identifier identifier();

    public BinaryRow minKey();

    public BinaryRow maxKey();

    public List<String> extraFiles();

    public static <T extends FileEntry> Collection<T> mergeEntries(Iterable<T> entries) {
        LinkedHashMap map = new LinkedHashMap();
        FileEntry.mergeEntries(entries, map);
        return map.values();
    }

    public static void mergeEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, Map<Identifier, ManifestEntry> map, @Nullable Integer manifestReadParallelism) {
        FileEntry.mergeEntries(FileEntry.readManifestEntries(manifestFile, manifestFiles, manifestReadParallelism), map);
    }

    public static <T extends FileEntry> void mergeEntries(Iterable<T> entries, Map<Identifier, T> map) {
        block4: for (FileEntry entry : entries) {
            Identifier identifier = entry.identifier();
            switch (entry.kind()) {
                case ADD: {
                    Preconditions.checkState(!map.containsKey(identifier), "Trying to add file %s which is already added.", identifier);
                    map.put(identifier, entry);
                    continue block4;
                }
                case DELETE: {
                    if (map.containsKey(identifier)) {
                        map.remove(identifier);
                        continue block4;
                    }
                    map.put(identifier, entry);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown value kind " + entry.kind().name());
        }
    }

    public static Iterable<ManifestEntry> readManifestEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, @Nullable Integer manifestReadParallelism) {
        return ManifestReadThreadPool.sequentialBatchedExecute(file -> manifestFile.read(file.fileName(), file.fileSize()), manifestFiles, manifestReadParallelism);
    }

    public static Set<Identifier> readDeletedEntries(ManifestFile manifestFile, List<ManifestFileMeta> manifestFiles, @Nullable Integer manifestReadParallelism) {
        return FileEntry.readDeletedEntries((ManifestFileMeta m) -> manifestFile.read(m.fileName(), m.fileSize(), Filter.alwaysTrue(), FileEntry.deletedFilter(), Filter.alwaysTrue()), manifestFiles, manifestReadParallelism);
    }

    public static <T extends FileEntry> Set<Identifier> readDeletedEntries(Function<ManifestFileMeta, List<T>> manifestReader, List<ManifestFileMeta> manifestFiles, @Nullable Integer manifestReadParallelism) {
        manifestFiles = manifestFiles.stream().filter(file -> file.numDeletedFiles() > 0L).collect(Collectors.toList());
        Function<ManifestFileMeta, List> processor = file -> ((List)manifestReader.apply((ManifestFileMeta)file)).stream().filter(e -> e.kind() == FileKind.DELETE).map(FileEntry::identifier).collect(Collectors.toList());
        Iterator identifiers = ManifestReadThreadPool.randomlyExecuteSequentialReturn(processor, manifestFiles, manifestReadParallelism);
        ConcurrentHashMap.KeySetView result = ConcurrentHashMap.newKeySet();
        while (identifiers.hasNext()) {
            result.add(identifiers.next());
        }
        return result;
    }

    public static Filter<InternalRow> deletedFilter() {
        Function<InternalRow, FileKind> getter = ManifestEntrySerializer.kindGetter();
        return row -> getter.apply((InternalRow)row) == FileKind.DELETE;
    }

    public static Filter<InternalRow> addFilter() {
        Function<InternalRow, FileKind> getter = ManifestEntrySerializer.kindGetter();
        return row -> getter.apply((InternalRow)row) == FileKind.ADD;
    }

    public static class Identifier {
        public final BinaryRow partition;
        public final int bucket;
        public final int level;
        public final String fileName;
        public final List<String> extraFiles;
        @Nullable
        private final byte[] embeddedIndex;
        @Nullable
        public final String externalPath;
        private Integer hash;

        public Identifier(BinaryRow partition, int bucket, int level, String fileName, List<String> extraFiles, @Nullable byte[] embeddedIndex, @Nullable String externalPath) {
            this.partition = partition;
            this.bucket = bucket;
            this.level = level;
            this.fileName = fileName;
            this.extraFiles = extraFiles;
            this.embeddedIndex = embeddedIndex;
            this.externalPath = externalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.bucket == that.bucket && this.level == that.level && Objects.equals(this.partition, that.partition) && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.extraFiles, that.extraFiles) && Objects.deepEquals(this.embeddedIndex, that.embeddedIndex) && Objects.deepEquals(this.externalPath, that.externalPath);
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = Objects.hash(this.partition, this.bucket, this.level, this.fileName, this.extraFiles, Arrays.hashCode(this.embeddedIndex), this.externalPath);
            }
            return this.hash;
        }

        public String toString() {
            return "{partition=" + this.partition + ", bucket=" + this.bucket + ", level=" + this.level + ", fileName=" + this.fileName + ", extraFiles=" + this.extraFiles + ", embeddedIndex=" + Arrays.toString(this.embeddedIndex) + ", externalPath=" + this.externalPath + '}';
        }

        public String toString(FileStorePathFactory pathFactory) {
            return pathFactory.getPartitionString(this.partition) + ", bucket " + this.bucket + ", level " + this.level + ", file " + this.fileName + ", extraFiles " + this.extraFiles + ", embeddedIndex " + Arrays.toString(this.embeddedIndex) + ", externalPath " + this.externalPath;
        }
    }
}

