/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.shade.netty4.io.netty.resolver.dns;

import java.net.InetSocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.shade.netty4.io.netty.channel.AddressedEnvelope;
import org.apache.paimon.shade.netty4.io.netty.channel.Channel;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelFuture;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelFutureListener;
import org.apache.paimon.shade.netty4.io.netty.channel.ChannelPromise;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.AbstractDnsOptPseudoRrRecord;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsQuery;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsQuestion;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsRecord;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsRecordType;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsResponse;
import org.apache.paimon.shade.netty4.io.netty.handler.codec.dns.DnsSection;
import org.apache.paimon.shade.netty4.io.netty.resolver.dns.DnsNameResolverException;
import org.apache.paimon.shade.netty4.io.netty.resolver.dns.DnsNameResolverTimeoutException;
import org.apache.paimon.shade.netty4.io.netty.resolver.dns.DnsQueryContextManager;
import org.apache.paimon.shade.netty4.io.netty.util.ReferenceCountUtil;
import org.apache.paimon.shade.netty4.io.netty.util.concurrent.Future;
import org.apache.paimon.shade.netty4.io.netty.util.concurrent.FutureListener;
import org.apache.paimon.shade.netty4.io.netty.util.concurrent.GenericFutureListener;
import org.apache.paimon.shade.netty4.io.netty.util.concurrent.Promise;
import org.apache.paimon.shade.netty4.io.netty.util.internal.ObjectUtil;
import org.apache.paimon.shade.netty4.io.netty.util.internal.SystemPropertyUtil;
import org.apache.paimon.shade.netty4.io.netty.util.internal.logging.InternalLogger;
import org.apache.paimon.shade.netty4.io.netty.util.internal.logging.InternalLoggerFactory;

abstract class DnsQueryContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DnsQueryContext.class);
    private static final long ID_REUSE_ON_TIMEOUT_DELAY_MILLIS = SystemPropertyUtil.getLong("org.apache.paimon.shade.netty4.io.netty.resolver.dns.idReuseOnTimeoutDelayMillis", 10000L);
    private final Future<? extends Channel> channelReadyFuture;
    private final Channel channel;
    private final InetSocketAddress nameServerAddr;
    private final DnsQueryContextManager queryContextManager;
    private final Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise;
    private final DnsQuestion question;
    private final DnsRecord[] additionals;
    private final DnsRecord optResource;
    private final boolean recursionDesired;
    private volatile Future<?> timeoutFuture;
    private int id = -1;

    DnsQueryContext(Channel channel, Future<? extends Channel> channelReadyFuture, InetSocketAddress nameServerAddr, DnsQueryContextManager queryContextManager, int maxPayLoadSize, boolean recursionDesired, DnsQuestion question, DnsRecord[] additionals, Promise<AddressedEnvelope<DnsResponse, InetSocketAddress>> promise) {
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
        this.queryContextManager = ObjectUtil.checkNotNull(queryContextManager, "queryContextManager");
        this.channelReadyFuture = ObjectUtil.checkNotNull(channelReadyFuture, "channelReadyFuture");
        this.nameServerAddr = ObjectUtil.checkNotNull(nameServerAddr, "nameServerAddr");
        this.question = ObjectUtil.checkNotNull(question, "question");
        this.additionals = ObjectUtil.checkNotNull(additionals, "additionals");
        this.promise = ObjectUtil.checkNotNull(promise, "promise");
        this.recursionDesired = recursionDesired;
        this.optResource = maxPayLoadSize > 0 && !DnsQueryContext.hasOptRecord(additionals) ? new AbstractDnsOptPseudoRrRecord(maxPayLoadSize, 0, 0){} : null;
    }

    private static boolean hasOptRecord(DnsRecord[] additionals) {
        if (additionals != null && additionals.length > 0) {
            for (DnsRecord additional : additionals) {
                if (additional.type() != DnsRecordType.OPT) continue;
                return true;
            }
        }
        return false;
    }

    final boolean isDone() {
        return this.promise.isDone();
    }

    final DnsQuestion question() {
        return this.question;
    }

    protected abstract DnsQuery newQuery(int var1, InetSocketAddress var2);

    protected abstract String protocol();

    final ChannelFuture writeQuery(long queryTimeoutMillis, boolean flush) {
        assert (this.id == -1) : this.getClass().getSimpleName() + ".writeQuery(...) can only be executed once.";
        this.id = this.queryContextManager.add(this.nameServerAddr, this);
        this.promise.addListener((GenericFutureListener<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>>)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

            @Override
            public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                Throwable cause;
                Future timeoutFuture = DnsQueryContext.this.timeoutFuture;
                if (timeoutFuture != null) {
                    DnsQueryContext.this.timeoutFuture = null;
                    timeoutFuture.cancel(false);
                }
                if ((cause = future.cause()) instanceof DnsNameResolverTimeoutException || cause instanceof CancellationException) {
                    DnsQueryContext.this.channel.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            DnsQueryContext.this.removeFromContextManager(DnsQueryContext.this.nameServerAddr);
                        }
                    }, ID_REUSE_ON_TIMEOUT_DELAY_MILLIS, TimeUnit.MILLISECONDS);
                } else {
                    DnsQueryContext.this.removeFromContextManager(DnsQueryContext.this.nameServerAddr);
                }
            }
        });
        DnsQuestion question = this.question();
        DnsQuery query = this.newQuery(this.id, this.nameServerAddr);
        query.setRecursionDesired(this.recursionDesired);
        query.addRecord(DnsSection.QUESTION, question);
        for (DnsRecord record : this.additionals) {
            query.addRecord(DnsSection.ADDITIONAL, record);
        }
        if (this.optResource != null) {
            query.addRecord(DnsSection.ADDITIONAL, this.optResource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} WRITE: {}, [{}: {}], {}", this.channel, this.protocol(), this.id, this.nameServerAddr, question);
        }
        return this.sendQuery(this.nameServerAddr, query, queryTimeoutMillis, flush);
    }

    private void removeFromContextManager(InetSocketAddress nameServerAddr) {
        DnsQueryContext self = this.queryContextManager.remove(nameServerAddr, this.id);
        assert (self == this) : "Removed DnsQueryContext is not the correct instance";
    }

    private ChannelFuture sendQuery(final InetSocketAddress nameServerAddr, final DnsQuery query, final long queryTimeoutMillis, boolean flush) {
        final ChannelPromise writePromise = this.channel.newPromise();
        if (this.channelReadyFuture.isSuccess()) {
            this.writeQuery(nameServerAddr, query, queryTimeoutMillis, flush, writePromise);
        } else {
            Throwable cause = this.channelReadyFuture.cause();
            if (cause != null) {
                this.failQuery(query, cause, writePromise);
            } else {
                this.channelReadyFuture.addListener((GenericFutureListener<Future<? extends Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                    @Override
                    public void operationComplete(Future<? super Channel> future) {
                        if (future.isSuccess()) {
                            DnsQueryContext.this.writeQuery(nameServerAddr, query, queryTimeoutMillis, true, writePromise);
                        } else {
                            Throwable cause = future.cause();
                            DnsQueryContext.this.failQuery(query, cause, writePromise);
                        }
                    }
                });
            }
        }
        return writePromise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failQuery(DnsQuery query, Throwable cause, ChannelPromise writePromise) {
        try {
            this.promise.tryFailure(cause);
            writePromise.tryFailure(cause);
        }
        finally {
            ReferenceCountUtil.release(query);
        }
    }

    private void writeQuery(InetSocketAddress nameServerAddr, DnsQuery query, final long queryTimeoutMillis, boolean flush, ChannelPromise promise) {
        ChannelFuture writeFuture;
        ChannelFuture channelFuture = writeFuture = flush ? this.channel.writeAndFlush(query, promise) : this.channel.write(query, promise);
        if (writeFuture.isDone()) {
            this.onQueryWriteCompletion(queryTimeoutMillis, writeFuture);
        } else {
            writeFuture.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    DnsQueryContext.this.onQueryWriteCompletion(queryTimeoutMillis, writeFuture);
                }
            });
        }
    }

    private void onQueryWriteCompletion(final long queryTimeoutMillis, ChannelFuture writeFuture) {
        if (!writeFuture.isSuccess()) {
            this.finishFailure("failed to send a query '" + this.id + "' via " + this.protocol(), writeFuture.cause(), false);
            return;
        }
        if (queryTimeoutMillis > 0L) {
            this.timeoutFuture = this.channel.eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    if (DnsQueryContext.this.promise.isDone()) {
                        return;
                    }
                    DnsQueryContext.this.finishFailure("query '" + DnsQueryContext.this.id + "' via " + DnsQueryContext.this.protocol() + " timed out after " + queryTimeoutMillis + " milliseconds", null, true);
                }
            }, queryTimeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    void finishSuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        DnsResponse res = envelope.content();
        if (res.count(DnsSection.QUESTION) != 1) {
            logger.warn("{} Received a DNS response with invalid number of questions. Expected: 1, found: {}", (Object)this.channel, (Object)envelope);
        } else if (!this.question().equals(res.recordAt(DnsSection.QUESTION))) {
            logger.warn("{} Received a mismatching DNS response. Expected: [{}], found: {}", this.channel, this.question(), envelope);
        } else if (this.trySuccess(envelope)) {
            return;
        }
        envelope.release();
    }

    private boolean trySuccess(AddressedEnvelope<? extends DnsResponse, InetSocketAddress> envelope) {
        return this.promise.trySuccess(envelope);
    }

    final boolean finishFailure(String message, Throwable cause, boolean timeout2) {
        if (this.promise.isDone()) {
            return false;
        }
        DnsQuestion question = this.question();
        StringBuilder buf = new StringBuilder(message.length() + 128);
        buf.append('[').append(this.id).append(": ").append(this.nameServerAddr).append("] ").append(question).append(' ').append(message).append(" (no stack trace available)");
        DnsNameResolverException e = timeout2 ? new DnsNameResolverTimeoutException(this.nameServerAddr, question, buf.toString()) : new DnsNameResolverException(this.nameServerAddr, question, buf.toString(), cause);
        return this.promise.tryFailure(e);
    }

    static {
        logger.debug("-Dio.netty.resolver.dns.idReuseOnTimeoutDelayMillis: {}", (Object)ID_REUSE_ON_TIMEOUT_DELAY_MILLIS);
    }
}

