/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.testutils.junit.parameterized.ParameterizedTestExtension;
import org.apache.paimon.testutils.junit.parameterized.Parameters;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class FilterPushdownWithSchemaChangeITCase
extends CatalogITCaseBase {
    private final String fileFormat;

    public FilterPushdownWithSchemaChangeITCase(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    @Parameters(name="file-format = {0}")
    public static List<String> fileFormat() {
        return Arrays.asList("parquet", "orc", "avro");
    }

    @TestTemplate
    public void testDecimalToDecimal() {
        this.sql("CREATE TABLE T (  id INT,  f DECIMAL(5, 2)) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111.32)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f DECIMAL(6, 3))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 111.321", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.320")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.321", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.320", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.320")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111.321", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.320")})});
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T (  id INT,  f DECIMAL(6, 3)) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111.321), (2, 111.331)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f DECIMAL(5, 2))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f > 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, new BigDecimal("111.33")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.32")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, new BigDecimal("111.33")})});
    }

    @TestTemplate
    public void testNumericPrimitiveToDecimal() {
        String ddl = "CREATE TABLE T (  id INT,  f DECIMAL(5, 2)) with (  'file.format' = '%s')";
        this.sql(ddl, this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111.32)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f DOUBLE)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 111.321", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 111.32})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.321", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.320", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 111.32})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111.321", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 111.32})});
        this.sql("DROP TABLE T", new Object[0]);
        this.sql(ddl, this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111.32), (2, 112.33)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f INT)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 112", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 111})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f > 112", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 111})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, 112})});
    }

    @TestTemplate
    public void testDecimalToNumericPrimitive() {
        this.sql("CREATE TABLE T (  id INT,  f INT) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f DECIMAL(5, 2))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 111.01", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.00")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.01", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.00", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.00")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111.01", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.00")})});
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T (  id INT,  f DOUBLE) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 111.321), (2, 111.331)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f DECIMAL(5, 2))", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f > 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, new BigDecimal("111.33")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, new BigDecimal("111.32")})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 111.32", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, new BigDecimal("111.33")})});
    }

    @TestTemplate
    public void testNumericPrimitive() {
        this.sql("CREATE TABLE T (  id INT,  f TINYINT) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, CAST (127 AS TINYINT))", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f INT)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 128", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 127})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 383", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 127})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 127", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 127})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 383", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 127", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 383", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 127})});
        this.sql("DROP TABLE T", new Object[0]);
        this.sql("CREATE TABLE T (  id INT,  f INT) with (  'file.format' = '%s')", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, 2147483647), (2, -2147483648)", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f BIGINT)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f < 2147483648", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Integer.MAX_VALUE}), Row.of((Object[])new Object[]{2, Integer.MIN_VALUE})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f > 2147483648", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 2147483647", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, Integer.MAX_VALUE})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 2147483648", new Object[0])).isEmpty();
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 2147483647", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, Integer.MIN_VALUE})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 2147483648", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{1, Integer.MAX_VALUE}), Row.of((Object[])new Object[]{2, Integer.MIN_VALUE})});
    }

    @TestTemplate
    public void testNumericToString() {
        this.sql("CREATE TABLE T (  id INT,  f STRING) with (  'file.format' = '%s');", this.fileFormat);
        this.sql("INSERT INTO T VALUES (1, '1'), (2, '111')", new Object[0]);
        this.sql("ALTER TABLE T MODIFY (f INT)", new Object[0]);
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f > 2", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, 111})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f = 1", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{1, 1})});
        Assertions.assertThat(this.sql("SELECT * FROM T WHERE f <> 1", new Object[0])).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{2, 111})});
    }
}

