/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.planner.factories.TestValuesTableFactory;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.shade.guava30.com.google.common.collect.ImmutableList;
import org.apache.paimon.utils.BlockingIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FirstRowITCase
extends CatalogITCaseBase {
    @Override
    protected List<String> ddl() {
        return Collections.singletonList("CREATE TABLE IF NOT EXISTS T (a INT, b INT, c STRING, PRIMARY KEY (a) NOT ENFORCED) WITH ('merge-engine'='first-row', 'file.format'='avro', 'changelog-producer' = 'lookup');");
    }

    @Test
    public void testBatchQueryNoChangelog() {
        this.sql("CREATE TABLE T_NO_CHANGELOG (a INT, b INT, c STRING, PRIMARY KEY (a) NOT ENFORCED) WITH ('merge-engine'='first-row')", new Object[0]);
        this.testBatchQuery("T_NO_CHANGELOG");
    }

    @Test
    public void testBatchQuery() {
        this.testBatchQuery("T");
    }

    private void testBatchQuery(String table) {
        this.batchSql("INSERT INTO %s VALUES (1, 1, '1'), (1, 2, '2')", table);
        List<Row> result = this.batchSql("SELECT * FROM %s", table);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, 1, "1"})});
        result = this.batchSql("SELECT c FROM %s", table);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{"1"})});
    }

    @Test
    public void testStreamingRead() throws Exception {
        BlockingIterator<Row, Row> iterator = this.streamSqlBlockIter("SELECT * FROM T", new Object[0]);
        this.sql("INSERT INTO T VALUES(1, 1, '1'), (2, 2, '2'), (1, 3, '3'), (1, 4, '4')", new Object[0]);
        Assertions.assertThat((List)iterator.collect(2)).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, 1, "1"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2, 2, "2"})});
        this.sql("INSERT INTO T VALUES(1, 1, '1'), (2, 2, '2'), (1, 3, '3'), (3, 3, '3'), (4, 4, '4'), (5, 5, '5'), (6, 6, '6'), (7, 7, '7')", new Object[0]);
        Assertions.assertThat((List)iterator.collect(5)).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{3, 3, "3"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{4, 4, "4"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{5, 5, "5"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{6, 6, "6"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{7, 7, "7"})});
        this.sql("INSERT INTO T VALUES(7, 7, '8'), (8, 8, '8')", new Object[0]);
        Assertions.assertThat((List)iterator.collect(1)).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{8, 8, "8"})});
    }

    @Test
    public void testLocalMerge() {
        this.sql("CREATE TABLE IF NOT EXISTS T1 (a INT, b INT, c STRING, PRIMARY KEY (a, b) NOT ENFORCED) PARTITIONED BY (b) WITH ('merge-engine'='first-row', 'local-merge-buffer-size' = '5m', 'file.format'='avro', 'changelog-producer' = 'lookup');", new Object[0]);
        this.batchSql("INSERT INTO T1 VALUES (1, 1, '1'), (1, 1, '2'), (2, 3, '3')", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactlyInAnyOrder((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, 1, "1"}), Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{2, 3, "3"})});
    }

    @Test
    public void testIgnoreDelete() {
        this.sql("CREATE TABLE IF NOT EXISTS T1 (a INT, b INT, c STRING, PRIMARY KEY (a) NOT ENFORCED) WITH ('merge-engine'='first-row', 'ignore-delete' = 'true', 'changelog-producer' = 'lookup');", new Object[0]);
        ImmutableList input = ImmutableList.of((Object)Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, 1, "1"}), (Object)Row.ofKind((RowKind)RowKind.UPDATE_BEFORE, (Object[])new Object[]{1, 1, "1"}), (Object)Row.ofKind((RowKind)RowKind.UPDATE_AFTER, (Object[])new Object[]{1, 2, "2"}));
        String id = TestValuesTableFactory.registerData((Collection)input);
        this.sql("CREATE TEMPORARY TABLE source (a INT, b INT, c STRING) WITH ('connector'='values', 'bounded'='true', 'data-id'='%s')", id);
        this.batchSql("INSERT INTO T1 SELECT * FROM source", new Object[0]);
        List<Row> result = this.batchSql("SELECT * FROM T1", new Object[0]);
        Assertions.assertThat(result).containsExactly((Object[])new Row[]{Row.ofKind((RowKind)RowKind.INSERT, (Object[])new Object[]{1, 1, "1"})});
    }
}

