/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.DateTimeUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlinkAnalyzeTableITCase
extends CatalogITCaseBase {
    @Test
    public void testAnalyzeTable() throws Catalog.TableNotExistException {
        this.sql("CREATE TABLE T ( id STRING, name STRING, i INT, l bigint, PRIMARY KEY (id) NOT ENFORCED ) WITH ( 'bucket' = '2' )", new Object[0]);
        this.sql("INSERT INTO T VALUES ('1', 'a', 1, 1)", new Object[0]);
        this.sql("INSERT INTO T VALUES ('2', 'aaa', 1, 2)", new Object[0]);
        this.sql("ANALYZE TABLE T COMPUTE STATISTICS", new Object[0]);
        FileStoreTable table = this.paimonTable("T");
        Optional statisticsOpt = table.statistics();
        Assertions.assertThat((boolean)statisticsOpt.isPresent()).isTrue();
        Statistics stats = (Statistics)statisticsOpt.get();
        Assertions.assertThat((boolean)stats.mergedRecordCount().isPresent()).isTrue();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)stats.mergedRecordCount().getAsLong());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.mergedRecordSize().isPresent());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)stats.colStats().isEmpty());
        Optional newStats = table.statistics();
        Assertions.assertThat((boolean)newStats.isPresent()).isTrue();
        Assertions.assertThat(newStats.get()).isSameAs((Object)stats);
        newStats = table.copy(Collections.singletonMap("a", "b")).statistics();
        Assertions.assertThat((boolean)newStats.isPresent()).isTrue();
        Assertions.assertThat(newStats.get()).isSameAs((Object)stats);
    }

    @Test
    public void testAnalyzeTableColumn() throws Catalog.TableNotExistException {
        this.sql("CREATE TABLE T (id STRING, name STRING, bytes_col BYTES, int_col INT, long_col bigint,\nfloat_col FLOAT, double_col DOUBLE, decimal_col DECIMAL(10, 5), boolean_col BOOLEAN, date_col DATE,\ntimestamp_col TIMESTAMP_LTZ, binary_col BINARY, varbinary_col VARBINARY, char_col CHAR(20), varchar_col VARCHAR(20),\ntinyint_col TINYINT, smallint_col SMALLINT, PRIMARY KEY (id) NOT ENFORCED ) WITH ( 'bucket' = '2' )", new Object[0]);
        this.sql("INSERT INTO T VALUES ('1', 'a', CAST('your_binary_data' AS BYTES), 1, 1, 1.0, 1.0, 13.12345, true, cast('2020-01-01' as date), cast('2024-01-01 00:00:00' as TIMESTAMP_LTZ), CAST('example binary1' AS BINARY), CAST('example binary1' AS VARBINARY), 'a', 'a',CAST(1 AS TINYINT), CAST(2 AS SMALLINT))", new Object[0]);
        this.sql("INSERT INTO T VALUES ('2', 'aaa', CAST('your_binary_data' AS BYTES), 1, 1, 1.0, 5.0, 12.12345, true, cast('2021-01-02' as date), cast('2024-01-02 00:00:00' as TIMESTAMP_LTZ), CAST('example binary1' AS BINARY), CAST('example binary1' AS VARBINARY), 'aaa', 'aaa', CAST(2 AS TINYINT), CAST(4 AS SMALLINT))", new Object[0]);
        this.sql("INSERT INTO T VALUES ('3', 'bbbb', CAST('data' AS BYTES), 4, 19, 7.0, 1.0, 14.12345, true, cast(NULL as date), cast('2024-01-02 05:00:00' as TIMESTAMP_LTZ), CAST(NULL AS BINARY), CAST('example binary1' AS VARBINARY), 'aaa', 'aaa', CAST(NULL AS TINYINT), CAST(4 AS SMALLINT))", new Object[0]);
        this.sql("INSERT INTO T VALUES ('4', 'aa', CAST(NULL AS BYTES), 1, 1, 1.0, 1.0, 14.12345, false, cast(NULL as date), cast(NULL as TIMESTAMP_LTZ), CAST(NULL AS BINARY), CAST('example' AS VARBINARY), 'aba', 'aaab', CAST(NULL AS TINYINT), CAST(4 AS SMALLINT))", new Object[0]);
        this.sql("ANALYZE TABLE T COMPUTE STATISTICS FOR ALL COLUMNS", new Object[0]);
        Optional statisticsOpt = this.paimonTable("T").statistics();
        Assertions.assertThat((boolean)statisticsOpt.isPresent()).isTrue();
        Statistics stats = (Statistics)statisticsOpt.get();
        Assertions.assertThat((boolean)stats.mergedRecordCount().isPresent()).isTrue();
        org.junit.jupiter.api.Assertions.assertEquals((long)4L, (long)stats.mergedRecordCount().getAsLong());
        Map colStats = stats.colStats();
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)0, (Long)4L, null, null, (Long)0L, (Long)1L, (Long)1L), colStats.get("id"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)1, (Long)4L, null, null, (Long)0L, (Long)2L, (Long)4L), colStats.get("name"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)2, null, null, null, (Long)1L, null, null), colStats.get("bytes_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)3, (Long)2L, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(4), (Long)0L, null, null), colStats.get("int_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)4, (Long)2L, (Comparable)Long.valueOf(1L), (Comparable)Long.valueOf(19L), (Long)0L, null, null), colStats.get("long_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)5, (Long)2L, (Comparable)Float.valueOf(1.0f), (Comparable)Float.valueOf(7.0f), (Long)0L, null, null), colStats.get("float_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)6, (Long)2L, (Comparable)Double.valueOf(1.0), (Comparable)Double.valueOf(5.0), (Long)0L, null, null), colStats.get("double_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)7, (Long)3L, (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("12.12345"), (int)10, (int)5), (Comparable)Decimal.fromBigDecimal((BigDecimal)new BigDecimal("14.12345"), (int)10, (int)5), (Long)0L, null, null), colStats.get("decimal_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)8, (Long)2L, null, null, (Long)0L, null, null), colStats.get("boolean_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)9, (Long)2L, (Comparable)Integer.valueOf(18262), (Comparable)Integer.valueOf(18629), (Long)2L, null, null), colStats.get("date_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)10, (Long)3L, (Comparable)DateTimeUtils.parseTimestampData((String)"2024-01-01 00:00:00", (int)0), (Comparable)DateTimeUtils.parseTimestampData((String)"2024-01-02 05:00:00", (int)0), (Long)1L, null, null), colStats.get("timestamp_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)11, null, null, null, (Long)2L, null, null), colStats.get("binary_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)12, null, null, null, (Long)0L, null, null), colStats.get("varbinary_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)13, (Long)3L, null, null, (Long)0L, (Long)20L, (Long)20L), colStats.get("char_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)14, (Long)3L, null, null, (Long)0L, (Long)2L, (Long)4L), colStats.get("varchar_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)15, (Long)2L, (Comparable)Byte.valueOf(new Integer(1).byteValue()), (Comparable)Byte.valueOf(new Integer(2).byteValue()), (Long)2L, null, null), colStats.get("tinyint_col"));
        org.junit.jupiter.api.Assertions.assertEquals((Object)ColStats.newColStats((int)16, (Long)2L, (Comparable)Short.valueOf(new Integer(2).shortValue()), (Comparable)Short.valueOf(new Integer(4).shortValue()), (Long)0L, null, null), colStats.get("smallint_col"));
    }
}

