/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionVisitor;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlCallExpression;
import org.apache.flink.table.types.AbstractDataType;
import org.apache.flink.table.types.DataType;
import org.apache.paimon.flink.utils.FlinkCatalogPropertiesUtil;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class FlinkCatalogPropertiesUtilTest {
    @Test
    public void testSerDeNonPhysicalColumns() {
        ArrayList<Object> columns = new ArrayList<Object>();
        columns.add(new Schema.UnresolvedComputedColumn("comp", (Expression)new SqlCallExpression("`k` * 2")));
        columns.add(new Schema.UnresolvedMetadataColumn("meta1", (AbstractDataType)DataTypes.VARCHAR((int)10), null, false));
        columns.add(new Schema.UnresolvedMetadataColumn("meta2", DataTypes.BIGINT().notNull(), "price", true, null));
        ArrayList<Object> resolvedColumns = new ArrayList<Object>();
        resolvedColumns.add(Column.physical((String)"phy1", (DataType)DataTypes.INT()));
        resolvedColumns.add(Column.physical((String)"phy2", (DataType)DataTypes.INT()));
        resolvedColumns.add(Column.computed((String)"comp", (ResolvedExpression)new TestResolvedExpression("`k` * 2", DataTypes.INT())));
        resolvedColumns.add(Column.metadata((String)"meta1", (DataType)DataTypes.VARCHAR((int)10), null, (boolean)false));
        resolvedColumns.add(Column.physical((String)"phy3", (DataType)DataTypes.INT()));
        resolvedColumns.add(Column.metadata((String)"meta2", (DataType)((DataType)DataTypes.BIGINT().notNull()), (String)"price", (boolean)true));
        Map serialized = FlinkCatalogPropertiesUtil.serializeNonPhysicalNewColumns((ResolvedSchema)new ResolvedSchema(resolvedColumns, Collections.emptyList(), null));
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "name"}), "comp");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "data-type"}), "INT");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "expr"}), "`k` * 2");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "name"}), "meta1");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "data-type"}), "VARCHAR(10)");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "metadata"}), "meta1");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "virtual"}), "false");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "name"}), "meta2");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "data-type"}), "BIGINT NOT NULL");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "metadata"}), "price");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 5, "virtual"}), "true");
        Assertions.assertThat((Map)serialized).containsExactlyInAnyOrderEntriesOf(expected);
        Schema.Builder builder = Schema.newBuilder();
        FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)2, (Schema.Builder)builder);
        FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)3, (Schema.Builder)builder);
        FlinkCatalogPropertiesUtil.deserializeNonPhysicalColumn((Map)serialized, (int)5, (Schema.Builder)builder);
        Assertions.assertThat((List)builder.build().getColumns()).containsExactly((Object[])columns.toArray(new Schema.UnresolvedColumn[0]));
    }

    @Test
    public void testSerDeWatermarkSpec() {
        WatermarkSpec watermarkSpec = WatermarkSpec.of((String)"test_time", (ResolvedExpression)new TestResolvedExpression("`test_time` - INTERVAL '0.001' SECOND", DataTypes.TIMESTAMP((int)3)));
        Map serialized = FlinkCatalogPropertiesUtil.serializeNewWatermarkSpec((WatermarkSpec)watermarkSpec);
        HashMap<String, String> expected = new HashMap<String, String>();
        String watermarkPrefix = FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", "watermark", 0});
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "rowtime"}), "test_time");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.expr"}), "`test_time` - INTERVAL '0.001' SECOND");
        expected.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{watermarkPrefix, "strategy.data-type"}), "TIMESTAMP(3)");
        Assertions.assertThat((Map)serialized).containsExactlyInAnyOrderEntriesOf(expected);
        Schema.Builder builder = Schema.newBuilder();
        FlinkCatalogPropertiesUtil.deserializeWatermarkSpec((Map)serialized, (Schema.Builder)builder);
        Assertions.assertThat((List)builder.build().getWatermarkSpecs()).hasSize(1);
        Schema.UnresolvedWatermarkSpec actual = (Schema.UnresolvedWatermarkSpec)builder.build().getWatermarkSpecs().get(0);
        Assertions.assertThat((String)actual.getColumnName()).isEqualTo(watermarkSpec.getRowtimeAttribute());
        Assertions.assertThat((String)actual.getWatermarkExpression().asSummaryString()).isEqualTo(watermarkSpec.getWatermarkExpression().asSummaryString());
    }

    @Test
    public void testNonPhysicalColumnsCount() {
        HashMap<String, String> oldStyleOptions = new HashMap<String, String>();
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 0, "name"}), "phy1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 0, "data-type"}), "INT");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 1, "name"}), "phy2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 1, "data-type"}), "INT NOT NULL");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "name"}), "comp");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "data-type"}), "INT");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 2, "expr"}), "`k` * 2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "name"}), "meta1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "data-type"}), "VARCHAR(10)");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "metadata"}), "meta1");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 3, "virtual"}), "false");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "name"}), "meta2");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "data-type"}), "BIGINT NOT NULL");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "metadata"}), "price");
        oldStyleOptions.put(FlinkCatalogPropertiesUtil.compoundKey((Object[])new Object[]{"schema", 4, "virtual"}), "true");
        oldStyleOptions.put("schema.unknown.name", "test");
        Assertions.assertThat((int)FlinkCatalogPropertiesUtil.nonPhysicalColumnsCount(oldStyleOptions, Arrays.asList("phy1", "phy2"))).isEqualTo(3);
    }

    private static class TestResolvedExpression
    implements ResolvedExpression {
        private final String name;
        private final DataType outputDataType;

        private TestResolvedExpression(String name, DataType outputDataType) {
            this.name = name;
            this.outputDataType = outputDataType;
        }

        public DataType getOutputDataType() {
            return this.outputDataType;
        }

        public List<ResolvedExpression> getResolvedChildren() {
            return Collections.emptyList();
        }

        public String asSummaryString() {
            return new SqlCallExpression(this.name).asSummaryString();
        }

        public String asSerializableString() {
            return this.name;
        }

        public List<Expression> getChildren() {
            return Collections.emptyList();
        }

        public <R> R accept(ExpressionVisitor<R> expressionVisitor) {
            return null;
        }
    }
}

