/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.TestCatalogFactory;
import org.apache.paimon.flink.FlinkGenericCatalogFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class FlinkGenericCatalogFactoryTest {
    private final FlinkGenericCatalogFactory genericCatalogFactory = new FlinkGenericCatalogFactory();
    @TempDir
    public static Path temporaryFolder;

    @Test
    public void testGenericCatalogOptionsFilter() {
        String path1 = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        String path2 = new File(temporaryFolder.toFile(), UUID.randomUUID().toString()).toString();
        TestCatalogFactory testCatalogFactory = new TestCatalogFactory();
        String catalogName = "test-catalog";
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("warehouse", path1);
        options.put(TestCatalogFactory.DEFAULT_DATABASE.key(), path2);
        FactoryUtil.DefaultCatalogContext context = new FactoryUtil.DefaultCatalogContext(catalogName, options, null, FlinkGenericCatalogFactoryTest.class.getClassLoader());
        CatalogFactory.Context flinkContext = this.genericCatalogFactory.filterContextOptions((CatalogFactory.Context)context, (CatalogFactory)testCatalogFactory);
        Map flinkOptions = flinkContext.getOptions();
        Assertions.assertThat((String)((String)flinkOptions.get(TestCatalogFactory.DEFAULT_DATABASE.key()))).isEqualTo((String)options.get(TestCatalogFactory.DEFAULT_DATABASE.key()));
        Assertions.assertThat((String)((String)flinkOptions.get("warehouse"))).isNull();
    }
}

