/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ObjectTableITCase
extends CatalogITCaseBase {
    @Test
    public void testIllegalObjectTable() {
        Assertions.assertThatThrownBy(() -> this.sql("CREATE TABLE T (a INT, b INT, c INT) WITH ('type' = 'object-table')", new Object[0])).rootCause().hasMessageContaining("Schema of Object Table can be empty or");
        Assertions.assertThatThrownBy(() -> this.sql("CREATE TABLE T WITH ('type' = 'object-table')", new Object[0])).rootCause().hasMessageContaining("Object table should have object-location option.");
    }

    @Test
    public void testObjectTableRefresh() throws IOException {
        Path objectLocation = new Path(this.path + "/object-location");
        LocalFileIO fileIO = LocalFileIO.create();
        this.sql("CREATE TABLE T WITH ('type' = 'object-table', 'object-location' = '%s')", objectLocation);
        fileIO.overwriteFileUtf8(new Path(objectLocation, "f0"), "1,2,3");
        this.sql("CALL sys.refresh_object_table('default.T')", new Object[0]);
        Assertions.assertThat(this.sql("SELECT name, length FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f0", 5L})});
        fileIO.overwriteFileUtf8(new Path(objectLocation, "f1"), "4,5,6");
        this.sql("CALL sys.refresh_object_table('default.T')", new Object[0]);
        Assertions.assertThat(this.sql("SELECT name, length FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f0", 5L}), Row.of((Object[])new Object[]{"f1", 5L})});
        fileIO.deleteQuietly(new Path(objectLocation, "f0"));
        this.sql("CALL sys.refresh_object_table('default.T')", new Object[0]);
        Assertions.assertThat(this.sql("SELECT name, length FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f1", 5L})});
        Assertions.assertThat(this.sql("SELECT name, length FROM T /*+ OPTIONS('scan.snapshot-id' = '1') */", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f0", 5L})});
        Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO T SELECT * FROM T", new Object[0])).rootCause().hasMessageContaining("Object table does not support Write.");
        Assertions.assertThat(this.sql("SELECT name, length FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f1", 5L})});
    }

    @Test
    public void testObjectTableRefreshInPrivileged() throws IOException {
        this.sql("CALL sys.init_file_based_privilege('root-passwd')", new Object[0]);
        this.tEnv.executeSql(String.format("CREATE CATALOG rootcat WITH (\n  'type' = 'paimon',\n  'warehouse' = '%s',\n  'user' = 'root',\n  'password' = 'root-passwd'\n)", this.path));
        this.tEnv.useCatalog("rootcat");
        Path objectLocation = new Path(this.path + "/object-location");
        LocalFileIO fileIO = LocalFileIO.create();
        this.sql("CREATE TABLE T WITH ('type' = 'object-table', 'object-location' = '%s')", objectLocation);
        fileIO.overwriteFileUtf8(new Path(objectLocation, "f0"), "1,2,3");
        this.sql("CALL sys.refresh_object_table('default.T')", new Object[0]);
        Assertions.assertThat(this.sql("SELECT name, length FROM T", new Object[0])).containsExactlyInAnyOrder((Object[])new Row[]{Row.of((Object[])new Object[]{"f0", 5L})});
    }
}

