/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.types.RowKind;

public class SerializableRowData
implements RowData,
Serializable {
    private final TypeSerializer<RowData> serializer;
    private transient RowData row;

    public SerializableRowData(RowData row, TypeSerializer<RowData> serializer) {
        this.row = row;
        this.serializer = serializer;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.serializer.serialize((Object)this.row, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.row = (RowData)this.serializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
    }

    public int getArity() {
        return this.row.getArity();
    }

    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    public void setRowKind(RowKind rowKind) {
        this.row.setRowKind(rowKind);
    }

    public boolean isNullAt(int i) {
        return this.row.isNullAt(i);
    }

    public boolean getBoolean(int i) {
        return this.row.getBoolean(i);
    }

    public byte getByte(int i) {
        return this.row.getByte(i);
    }

    public short getShort(int i) {
        return this.row.getShort(i);
    }

    public int getInt(int i) {
        return this.row.getInt(i);
    }

    public long getLong(int i) {
        return this.row.getLong(i);
    }

    public float getFloat(int i) {
        return this.row.getFloat(i);
    }

    public double getDouble(int i) {
        return this.row.getDouble(i);
    }

    public StringData getString(int i) {
        return this.row.getString(i);
    }

    public DecimalData getDecimal(int i, int precision, int scale) {
        return this.row.getDecimal(i, precision, scale);
    }

    public TimestampData getTimestamp(int i, int precision) {
        return this.row.getTimestamp(i, precision);
    }

    public <T> RawValueData<T> getRawValue(int i) {
        return this.row.getRawValue(i);
    }

    public byte[] getBinary(int i) {
        return this.row.getBinary(i);
    }

    public ArrayData getArray(int i) {
        return this.row.getArray(i);
    }

    public MapData getMap(int i) {
        return this.row.getMap(i);
    }

    public RowData getRow(int i, int rowArity) {
        return this.row.getRow(i, rowArity);
    }
}

