/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.List;
import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogTableITCase;
import org.apache.paimon.utils.BlockingIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class SystemTableITCase
extends CatalogTableITCase {
    @Test
    public void testBinlogTableStreamRead() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT, primary key (a) NOT ENFORCED) with ('changelog-producer' = 'lookup', 'bucket' = '2')", new Object[0]);
        BlockingIterator<Row, Row> iterator = this.streamSqlBlockIter("SELECT * FROM T$binlog /*+ OPTIONS('scan.mode' = 'latest') */", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 2)", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 3)", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, 2)", new Object[0]);
        List rows = iterator.collect(3);
        Assertions.assertThat((List)rows).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"+I", new Integer[]{1}, new Integer[]{2}}), Row.of((Object[])new Object[]{"+U", new Integer[]{1, 1}, new Integer[]{2, 3}}), Row.of((Object[])new Object[]{"+I", new Integer[]{2}, new Integer[]{2}})});
        iterator.close();
    }

    @Test
    public void testBinlogTableBatchRead() throws Exception {
        this.sql("CREATE TABLE T (a INT, b INT, primary key (a) NOT ENFORCED) with ('changelog-producer' = 'lookup', 'bucket' = '2')", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 2)", new Object[0]);
        this.sql("INSERT INTO T VALUES (1, 3)", new Object[0]);
        this.sql("INSERT INTO T VALUES (2, 2)", new Object[0]);
        List<Row> rows = this.sql("SELECT * FROM T$binlog /*+ OPTIONS('scan.mode' = 'latest') */", new Object[0]);
        Assertions.assertThat(rows).containsExactly((Object[])new Row[]{Row.of((Object[])new Object[]{"+I", new Integer[]{1}, new Integer[]{3}}), Row.of((Object[])new Object[]{"+I", new Integer[]{2}, new Integer[]{2}})});
    }

    @Test
    public void testIndexesTable() {
        this.sql("CREATE TABLE T (pt STRING, a INT, b STRING, PRIMARY KEY (pt, a) NOT ENFORCED) PARTITIONED BY (pt) with ('deletion-vectors.enabled'='true')", new Object[0]);
        this.sql("INSERT INTO T VALUES ('2024-10-01', 1, 'aaaaaaaaaaaaaaaaaaa'), ('2024-10-01', 2, 'b'), ('2024-10-01', 3, 'c')", new Object[0]);
        this.sql("INSERT INTO T VALUES ('2024-10-01', 1, 'a_new1'), ('2024-10-01', 3, 'c_new1')", new Object[0]);
        List<Row> rows = this.sql("SELECT * FROM `T$table_indexes` WHERE index_type = 'HASH'", new Object[0]);
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        Row row = rows.get(0);
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)"[2024-10-01]");
        Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)0);
        Assertions.assertThat((Object)row.getField(2)).isEqualTo((Object)"HASH");
        Assertions.assertThat((boolean)row.getField(3).toString().startsWith("index-")).isTrue();
        Assertions.assertThat((Object)row.getField(4)).isEqualTo((Object)12L);
        Assertions.assertThat((Object)row.getField(5)).isEqualTo((Object)3L);
        Assertions.assertThat((Object)row.getField(6)).isNull();
        rows = this.sql("SELECT * FROM `T$table_indexes` WHERE index_type = 'DELETION_VECTORS'", new Object[0]);
        Assertions.assertThat((int)rows.size()).isEqualTo(1);
        row = rows.get(0);
        Assertions.assertThat((Object)row.getField(0)).isEqualTo((Object)"[2024-10-01]");
        Assertions.assertThat((Object)row.getField(1)).isEqualTo((Object)0);
        Assertions.assertThat((Object)row.getField(2)).isEqualTo((Object)"DELETION_VECTORS");
        Assertions.assertThat((boolean)row.getField(3).toString().startsWith("index-")).isTrue();
        Assertions.assertThat((Object)row.getField(4)).isEqualTo((Object)33L);
        Assertions.assertThat((Object)row.getField(5)).isEqualTo((Object)1L);
        Assertions.assertThat((Object)row.getField(6)).isNotNull();
    }
}

