/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CreateTagFromTimestampAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CreateTagFromTimestampActionITTest
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.STRING(), DataTypes.STRING()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"k", "v"});

    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testCreateTagFromTimestampAction() throws Exception {
        FileStoreTable table = this.prepareTable();
        TableScan.Plan plan = table.newReadBuilder().newScan().plan();
        List<String> actual = this.getResult(table.newReadBuilder().newRead(), plan.splits(), ROW_TYPE);
        List<String> expected = Arrays.asList("+I[1, 2024-01-01]", "+I[2, 2024-01-02]", "+I[3, 2024-01-03]");
        Assertions.assertThat(actual).isEqualTo(expected);
        long ts = table.snapshotManager().latestSnapshot().timeMillis();
        String tag = "tag_test";
        this.createAction(CreateTagFromTimestampAction.class, "create_tag_from_timestamp", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--tag", tag, "--timestamp", Long.toString(ts)).run();
        Snapshot snapshot = (Snapshot)table.tagManager().tags().firstKey();
        Assertions.assertThat((boolean)table.tagManager().tagExists(tag)).isTrue();
        Assertions.assertThat((long)table.tagManager().tagCount()).isEqualTo(1L);
        Assertions.assertThat((long)snapshot.timeMillis()).isEqualTo(ts);
    }

    private FileStoreTable prepareTable() throws Exception {
        ReadWriteTableTestUtil.init(this.warehouse);
        RowType rowType = RowType.of((DataType[])new DataType[]{DataTypes.STRING(), DataTypes.STRING()}, (String[])new String[]{"k", "v"});
        String[] pk = new String[]{"k", "v"};
        FileStoreTable table = this.createFileStoreTable(rowType, Collections.singletonList("v"), new ArrayList<String>(Arrays.asList(pk)), Collections.singletonList("k"), Collections.emptyMap());
        StreamWriteBuilder writeBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = writeBuilder.newWrite();
        this.commit = writeBuilder.newCommit();
        this.writeData(this.rowData(BinaryString.fromString((String)"1"), BinaryString.fromString((String)"2024-01-01")));
        this.writeData(this.rowData(BinaryString.fromString((String)"2"), BinaryString.fromString((String)"2024-01-02")));
        this.writeData(this.rowData(BinaryString.fromString((String)"3"), BinaryString.fromString((String)"2024-01-03")));
        return table;
    }
}

