/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import org.apache.paimon.Snapshot;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.CreateTagFromWatermarkAction;
import org.apache.paimon.flink.util.ReadWriteTableTestUtil;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.tag.Tag;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CreateTagFromWatermarkActionITTest
extends ActionITCaseBase {
    @BeforeEach
    public void setUp() {
        ReadWriteTableTestUtil.init(this.warehouse);
    }

    @Test
    public void testCreateTagsFromSnapshotsWatermark() throws Exception {
        ReadWriteTableTestUtil.bEnv.executeSql("CREATE TABLE T ( k STRING, dt STRING, PRIMARY KEY (k, dt) NOT ENFORCED) PARTITIONED BY (dt) WITH ( 'bucket' = '1')");
        ReadWriteTableTestUtil.bEnv.executeSql("insert into T values('k1', '2024-01-02')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("insert into T/*+ OPTIONS('end-input.watermark'= '1000') */ values('k2', '2024-01-02')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("insert into T/*+ OPTIONS('end-input.watermark'= '2000') */ values('k3', '2024-01-02')").await();
        FileStoreTable table = this.getFileStoreTable("T");
        Snapshot snapshot2 = table.snapshotManager().snapshot(2L);
        long commitTime2 = snapshot2.timeMillis();
        long watermark2 = snapshot2.watermark();
        Snapshot snapshot3 = table.snapshotManager().snapshot(3L);
        long commitTime3 = snapshot3.timeMillis();
        long watermark3 = snapshot3.watermark();
        this.createAction(CreateTagFromWatermarkAction.class, "create_tag_from_watermark", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag", "tag2", "--watermark", Long.toString(watermark2 - 1L)).run();
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag2")).isTrue();
        Assertions.assertThat((Long)table.tagManager().getOrThrow("tag2").watermark()).isEqualTo(watermark2);
        Assertions.assertThat((long)table.tagManager().getOrThrow("tag2").timeMillis()).isEqualTo(commitTime2);
        this.createAction(CreateTagFromWatermarkAction.class, "create_tag_from_watermark", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag", "tag3", "--watermark", Long.toString(watermark2 + 1L)).run();
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag3")).isTrue();
        Assertions.assertThat((Long)table.tagManager().getOrThrow("tag3").watermark()).isEqualTo(watermark3);
        Assertions.assertThat((long)table.tagManager().getOrThrow("tag3").timeMillis()).isEqualTo(commitTime3);
    }

    @Test
    public void testCreateTagsFromTagsWatermark() throws Exception {
        ReadWriteTableTestUtil.bEnv.executeSql("CREATE TABLE T ( k STRING, dt STRING, PRIMARY KEY (k, dt) NOT ENFORCED) PARTITIONED BY (dt) WITH ( 'bucket' = '1')");
        ReadWriteTableTestUtil.bEnv.executeSql("insert into T/*+ OPTIONS('end-input.watermark'= '1000') */ values('k2', '2024-01-02')").await();
        ReadWriteTableTestUtil.bEnv.executeSql("CALL sys.create_tag('default.T', 'tag1', 1)").await();
        ReadWriteTableTestUtil.bEnv.executeSql("insert into T/*+ OPTIONS('end-input.watermark'= '2000', 'snapshot.num-retained.max' = '1', 'snapshot.num-retained.min' = '1') */ values('k2', '2024-01-02')").await();
        FileStoreTable table = this.getFileStoreTable("T");
        Assertions.assertThat((boolean)table.snapshotManager().snapshotExists(1L)).isFalse();
        Tag tagSnapshot1 = table.tagManager().getOrThrow("tag1");
        long tagsCommitTime = tagSnapshot1.timeMillis();
        long tagsWatermark = tagSnapshot1.watermark();
        Snapshot snapshot2 = table.snapshotManager().snapshot(2L);
        long commitTime2 = snapshot2.timeMillis();
        long watermark2 = snapshot2.watermark();
        Assertions.assertThat((tagsWatermark == 1000L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((watermark2 == 2000L ? 1 : 0) != 0).isTrue();
        this.createAction(CreateTagFromWatermarkAction.class, "create_tag_from_watermark", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag", "tag2", "--watermark", Long.toString(tagsWatermark - 1L)).run();
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag2")).isTrue();
        Assertions.assertThat((Long)table.tagManager().getOrThrow("tag2").watermark()).isEqualTo(tagsWatermark);
        Assertions.assertThat((long)table.tagManager().getOrThrow("tag2").timeMillis()).isEqualTo(tagsCommitTime);
        this.createAction(CreateTagFromWatermarkAction.class, "create_tag_from_watermark", "--warehouse", this.warehouse, "--database", this.database, "--table", "T", "--tag", "tag3", "--watermark", Long.toString(watermark2 - 1L)).run();
        Assertions.assertThat((boolean)table.tagManager().tagExists("tag3")).isTrue();
        Assertions.assertThat((Long)table.tagManager().getOrThrow("tag3").watermark()).isEqualTo(watermark2);
        Assertions.assertThat((long)table.tagManager().getOrThrow("tag3").timeMillis()).isEqualTo(commitTime2);
    }
}

