/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.MarkPartitionDoneAction;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.partition.file.SuccessFile;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.StreamWriteBuilder;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.SnapshotManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class MarkPartitionDoneActionITCase
extends ActionITCaseBase {
    private static final DataType[] FIELD_TYPES = new DataType[]{DataTypes.INT(), DataTypes.INT(), DataTypes.STRING(), DataTypes.INT()};
    private static final RowType ROW_TYPE = RowType.of((DataType[])FIELD_TYPES, (String[])new String[]{"partKey0", "partKey1", "dt", "value"});

    private static Stream<Arguments> testArguments() {
        return Stream.of(Arguments.of((Object[])new Object[]{true, "action"}), Arguments.of((Object[])new Object[]{false, "action"}), Arguments.of((Object[])new Object[]{true, "procedure_indexed"}), Arguments.of((Object[])new Object[]{false, "procedure_indexed"}), Arguments.of((Object[])new Object[]{true, "procedure_named"}), Arguments.of((Object[])new Object[]{false, "procedure_named"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testPartitionMarkDoneWithSinglePartitionKey(boolean hasPk, String invoker) throws Exception {
        FileStoreTable table = this.prepareTable(hasPk);
        switch (invoker) {
            case "action": {
                this.createAction(MarkPartitionDoneAction.class, "mark_partition_done", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--partition", "partKey0=0").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.mark_partition_done('%s.%s', 'partKey0 = 0')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.mark_partition_done(`table` => '%s.%s', partitions => 'partKey0 = 0')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Path successPath = new Path(table.location(), "partKey0=0/_SUCCESS");
        SuccessFile successFile = SuccessFile.safelyFromPath((FileIO)table.fileIO(), (Path)successPath);
        Assertions.assertThat((Object)successFile).isNotNull();
    }

    @ParameterizedTest
    @MethodSource(value={"testArguments"})
    public void testDropPartitionWithMultiplePartitionKey(boolean hasPk, String invoker) throws Exception {
        FileStoreTable table = this.prepareTable(hasPk);
        switch (invoker) {
            case "action": {
                this.createAction(MarkPartitionDoneAction.class, "mark_partition_done", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--partition", "partKey0=0,partKey1=1", "--partition", "partKey0=1,partKey1=0").run();
                break;
            }
            case "procedure_indexed": {
                this.executeSQL(String.format("CALL sys.mark_partition_done('%s.%s', 'partKey0=0,partKey1=1;partKey0=1,partKey1=0')", this.database, this.tableName));
                break;
            }
            case "procedure_named": {
                this.executeSQL(String.format("CALL sys.mark_partition_done(`table` => '%s.%s', partitions => 'partKey0=0,partKey1=1;partKey0=1,partKey1=0')", this.database, this.tableName));
                break;
            }
            default: {
                throw new UnsupportedOperationException(invoker);
            }
        }
        Path successPath1 = new Path(table.location(), "partKey0=0/partKey1=1/_SUCCESS");
        SuccessFile successFile1 = SuccessFile.safelyFromPath((FileIO)table.fileIO(), (Path)successPath1);
        Assertions.assertThat((Object)successFile1).isNotNull();
        Path successPath2 = new Path(table.location(), "partKey0=1/partKey1=0/_SUCCESS");
        SuccessFile successFile2 = SuccessFile.safelyFromPath((FileIO)table.fileIO(), (Path)successPath2);
        Assertions.assertThat((Object)successFile2).isNotNull();
    }

    private FileStoreTable prepareTable(boolean hasPk) throws Exception {
        FileStoreTable table = this.createFileStoreTable(ROW_TYPE, Arrays.asList("partKey0", "partKey1"), hasPk ? Arrays.asList("partKey0", "partKey1", "dt") : Collections.emptyList(), hasPk ? Collections.emptyList() : Collections.singletonList("dt"), new HashMap<String, String>());
        SnapshotManager snapshotManager = table.snapshotManager();
        StreamWriteBuilder streamWriteBuilder = table.newStreamWriteBuilder().withCommitUser(this.commitUser);
        this.write = streamWriteBuilder.newWrite();
        this.commit = streamWriteBuilder.newCommit();
        this.writeData(this.rowData(0, 0, BinaryString.fromString((String)"2023-01-12"), 101), this.rowData(0, 0, BinaryString.fromString((String)"2023-01-12"), 102), this.rowData(0, 0, BinaryString.fromString((String)"2023-01-13"), 103));
        this.writeData(this.rowData(0, 1, BinaryString.fromString((String)"2023-01-14"), 110), this.rowData(0, 1, BinaryString.fromString((String)"2023-01-15"), 120), this.rowData(0, 1, BinaryString.fromString((String)"2023-01-16"), 130));
        this.writeData(this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 2), this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 3), this.rowData(1, 0, BinaryString.fromString((String)"2023-01-17"), 5));
        this.writeData(this.rowData(1, 1, BinaryString.fromString((String)"2023-01-18"), 82), this.rowData(1, 1, BinaryString.fromString((String)"2023-01-19"), 90), this.rowData(1, 1, BinaryString.fromString((String)"2023-01-20"), 97));
        Snapshot snapshot = snapshotManager.snapshot(snapshotManager.latestSnapshotId().longValue());
        Assertions.assertThat((long)snapshot.id()).isEqualTo(4L);
        Assertions.assertThat((Comparable)snapshot.commitKind()).isEqualTo((Object)Snapshot.CommitKind.APPEND);
        return table;
    }
}

