/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.action.CompactActionITCaseBase;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.source.DataSplit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MinorCompactActionITCase
extends CompactActionITCaseBase {
    @Test
    @Timeout(value=60L)
    public void testBatchMinorCompactStrategy() throws Exception {
        FileStoreTable table = this.prepareTable(Arrays.asList("dt", "hh"), Arrays.asList("dt", "hh", "k"), Collections.emptyList(), Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true"));
        this.writeData(this.rowData(1, 100, 15, BinaryString.fromString((String)"20221208")), this.rowData(1, 100, 16, BinaryString.fromString((String)"20221208")));
        this.writeData(this.rowData(2, 100, 15, BinaryString.fromString((String)"20221208")), this.rowData(2, 100, 16, BinaryString.fromString((String)"20221208")));
        this.checkLatestSnapshot(table, 2L, Snapshot.CommitKind.APPEND);
        CompactAction action = this.createAction(CompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--compact_strategy", "minor", "--table_conf", CoreOptions.NUM_SORTED_RUNS_COMPACTION_TRIGGER.key() + "=3");
        StreamExecutionEnvironment env = this.streamExecutionEnvironmentBuilder().batchMode().build();
        action.withStreamExecutionEnvironment(env).build();
        env.execute();
        this.checkLatestSnapshot(table, 2L, Snapshot.CommitKind.APPEND);
        this.writeData(this.rowData(2, 100, 15, BinaryString.fromString((String)"20221208")));
        env = this.streamExecutionEnvironmentBuilder().batchMode().build();
        action.withStreamExecutionEnvironment(env).build();
        env.execute();
        this.checkLatestSnapshot(table, 4L, Snapshot.CommitKind.COMPACT);
        List splits = table.newSnapshotReader().read().dataSplits();
        Assertions.assertThat((int)splits.size()).isEqualTo(2);
        for (DataSplit split : splits) {
            Assertions.assertThat((int)split.dataFiles().size()).isEqualTo(split.partition().getInt(1) == 16 ? 2 : 1);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testBatchFullCompactStrategy() throws Exception {
        FileStoreTable table = this.prepareTable(Arrays.asList("dt", "hh"), Arrays.asList("dt", "hh", "k"), Collections.emptyList(), Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true"));
        this.writeData(this.rowData(1, 100, 15, BinaryString.fromString((String)"20221208")), this.rowData(1, 100, 16, BinaryString.fromString((String)"20221208")));
        this.writeData(this.rowData(2, 100, 15, BinaryString.fromString((String)"20221208")), this.rowData(2, 100, 16, BinaryString.fromString((String)"20221208")));
        this.checkLatestSnapshot(table, 2L, Snapshot.CommitKind.APPEND);
        CompactAction action = this.createAction(CompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--compact_strategy", "full", "--table_conf", CoreOptions.NUM_SORTED_RUNS_COMPACTION_TRIGGER.key() + "=3");
        StreamExecutionEnvironment env = this.streamExecutionEnvironmentBuilder().batchMode().build();
        action.withStreamExecutionEnvironment(env).build();
        env.execute();
        this.checkLatestSnapshot(table, 3L, Snapshot.CommitKind.COMPACT);
        List splits = table.newSnapshotReader().read().dataSplits();
        Assertions.assertThat((int)splits.size()).isEqualTo(2);
        for (DataSplit split : splits) {
            Assertions.assertThat((int)split.dataFiles().size()).isEqualTo(1);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testStreamingFullCompactStrategy() throws Exception {
        this.prepareTable(Arrays.asList("dt", "hh"), Arrays.asList("dt", "hh", "k"), Collections.emptyList(), Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true"));
        CompactAction action = this.createAction(CompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--compact_strategy", "full", "--table_conf", CoreOptions.NUM_SORTED_RUNS_COMPACTION_TRIGGER.key() + "=3");
        StreamExecutionEnvironment env = this.streamExecutionEnvironmentBuilder().streamingMode().build();
        Assertions.assertThatThrownBy(() -> action.withStreamExecutionEnvironment(env).build()).hasMessage("The full compact strategy is only supported in batch mode. Please add -Dexecution.runtime-mode=BATCH.");
    }

    @Test
    @Timeout(value=60L)
    public void testCompactStrategyWithWrongUsage() throws Exception {
        this.prepareTable(Arrays.asList("dt", "hh"), Arrays.asList("dt", "hh", "k"), Collections.emptyList(), Collections.singletonMap(CoreOptions.WRITE_ONLY.key(), "true"));
        Assertions.assertThatThrownBy(() -> this.createAction(CompactAction.class, "compact", "--warehouse", this.warehouse, "--database", this.database, "--table", this.tableName, "--compact_strategy", "wrong_usage", "--table_conf", CoreOptions.NUM_SORTED_RUNS_COMPACTION_TRIGGER.key() + "=3")).hasMessage("The compact strategy only supports 'full' or 'minor', but 'wrong_usage' is configured.");
    }
}

