/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.fileindex.FileIndexFormat;
import org.apache.paimon.fileindex.FileIndexReader;
import org.apache.paimon.fileindex.FileIndexResult;
import org.apache.paimon.flink.action.ActionITCaseBase;
import org.apache.paimon.flink.action.RewriteFileIndexAction;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.SeekableInputStream;
import org.apache.paimon.manifest.ManifestEntry;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.predicate.PredicateVisitor;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class RewriteFileIndexActionITCase
extends ActionITCaseBase {
    @Test
    public void testFileIndexAddIndex() throws Exception {
        TableEnvironment tEnv = this.tableEnvironmentBuilder().batchMode().build();
        tEnv.executeSql(String.format("CREATE CATALOG PAIMON WITH ('type'='paimon', 'warehouse'='%s');", this.warehouse));
        tEnv.useCatalog("PAIMON");
        tEnv.executeSql("CREATE DATABASE IF NOT EXISTS test_db;").await();
        tEnv.executeSql("USE test_db").await();
        tEnv.executeSql("CREATE TABLE T ( k INT, v STRING, hh INT, dt STRING) PARTITIONED BY (dt, hh) WITH ( 'write-only' = 'true', 'bucket' = '-1')");
        tEnv.executeSql("INSERT INTO T VALUES (1, '100', 15, '20221208'), (1, '100', 16, '20221208'), (1, '100', 15, '20221209')");
        tEnv.getConfig().set(TableConfigOptions.TABLE_DML_SYNC, (Object)true);
        tEnv.executeSql("ALTER TABLE T SET ('file-index.bloom-filter.columns'='k,v')");
        if (ThreadLocalRandom.current().nextBoolean()) {
            StreamExecutionEnvironment env = this.streamExecutionEnvironmentBuilder().streamingMode().build();
            this.createAction(RewriteFileIndexAction.class, "rewrite_file_index", "--warehouse", this.warehouse, "--identifier", "test_db.T").withStreamExecutionEnvironment(env).run();
        } else {
            this.executeSQL("CALL sys.rewrite_file_index('test_db.T')");
        }
        FileStoreTable table = (FileStoreTable)this.catalog.getTable(new Identifier("test_db", "T"));
        List list = table.store().newScan().plan().files();
        for (ManifestEntry entry : list) {
            List extraFiles = entry.file().extraFiles().stream().filter(s -> s.endsWith(".index")).collect(Collectors.toList());
            Assertions.assertThat((int)extraFiles.size()).isEqualTo(1);
            String file = (String)extraFiles.get(0);
            Path indexFilePath = table.store().pathFactory().createDataFilePathFactory(entry.partition(), entry.bucket()).toAlignedPath(file, entry.file());
            FileIndexFormat.Reader reader = FileIndexFormat.createReader((SeekableInputStream)table.fileIO().newInputStream(indexFilePath), (RowType)table.rowType());
            Throwable throwable = null;
            try {
                Set readerSetK = reader.readColumnIndex("k");
                Assertions.assertThat((int)readerSetK.size()).isEqualTo(1);
                Predicate predicateK = new PredicateBuilder(table.rowType()).equal(0, (Object)1);
                for (FileIndexReader fileIndexReader : readerSetK) {
                    Assertions.assertThat((boolean)((FileIndexResult)predicateK.visit((PredicateVisitor)fileIndexReader)).remain()).isTrue();
                }
                predicateK = new PredicateBuilder(table.rowType()).equal(0, (Object)4);
                for (FileIndexReader fileIndexReader : readerSetK) {
                    Assertions.assertThat((boolean)((FileIndexResult)predicateK.visit((PredicateVisitor)fileIndexReader)).remain()).isFalse();
                }
                Set readerSetV = reader.readColumnIndex("v");
                Assertions.assertThat((int)readerSetV.size()).isEqualTo(1);
                Predicate predicateV = new PredicateBuilder(table.rowType()).equal(1, (Object)BinaryString.fromString((String)"100"));
                for (FileIndexReader fileIndexReader : readerSetV) {
                    Assertions.assertThat((boolean)((FileIndexResult)predicateV.visit((PredicateVisitor)fileIndexReader)).remain()).isTrue();
                }
                predicateV = new PredicateBuilder(table.rowType()).equal(1, (Object)BinaryString.fromString((String)"101"));
                for (FileIndexReader fileIndexReader : readerSetV) {
                    Assertions.assertThat((boolean)((FileIndexResult)predicateV.visit((PredicateVisitor)fileIndexReader)).remain()).isFalse();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
    }
}

