/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.catalog.CatalogFactory;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.compact.UnawareBucketCompactor;
import org.apache.paimon.flink.source.FileStoreSourceReaderTest;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.utils.ExecutorThreadFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class UnawareBucketCompactorTest {
    @TempDir
    private java.nio.file.Path dir;
    private String tableName = "Orders1";
    private String dataBaseName = "my_db";
    private Catalog catalog;

    @Test
    public void testGaugeCollection() throws Exception {
        this.createTable();
        ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorThreadFactory(Thread.currentThread().getName() + "-append-only-compact-worker"));
        final HashMap gaugeMap = new HashMap();
        final HashMap counterMap = new HashMap();
        UnawareBucketCompactor unawareBucketCompactor = new UnawareBucketCompactor((FileStoreTable)this.catalog.getTable(this.identifier()), "10086", () -> executorService, (MetricGroup)new FileStoreSourceReaderTest.DummyMetricGroup(){

            @Override
            public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
                gaugeMap.put(name, gauge);
                return null;
            }

            @Override
            public MetricGroup addGroup(String name) {
                return this;
            }

            @Override
            public MetricGroup addGroup(String key, String value) {
                return this;
            }

            @Override
            public Counter counter(String name) {
                SimpleCounter counter = new SimpleCounter();
                counterMap.put(name, counter);
                return counter;
            }
        });
        for (int i = 0; i < 320; ++i) {
            unawareBucketCompactor.processElement((UnawareAppendCompactionTask)new MockCompactionTask());
            Thread.sleep(250L);
        }
        double compactionThreadBusy = (Double)((Gauge)gaugeMap.get("compactionThreadBusy")).getValue();
        double compactionAvgTime = (Double)((Gauge)gaugeMap.get("avgCompactionTime")).getValue();
        long compactionsCompletedCount = ((Counter)counterMap.get("compactionCompletedCount")).getCount();
        long compactionsQueuedCount = ((Counter)counterMap.get("compactionQueuedCount")).getCount();
        Assertions.assertThat((double)compactionThreadBusy).isGreaterThan(45.0).isLessThan(55.0);
        Assertions.assertThat((double)compactionAvgTime).isGreaterThan(120.0).isLessThan(140.0);
        Assertions.assertThat((long)compactionsCompletedCount).isEqualTo(320L);
        Assertions.assertThat((long)compactionsQueuedCount).isEqualTo(0L);
    }

    protected Catalog getCatalog() {
        if (this.catalog == null) {
            Options options = new Options();
            options.set(CatalogOptions.WAREHOUSE, (Object)new Path(this.dir.toString()).toUri().toString());
            this.catalog = CatalogFactory.createCatalog((CatalogContext)CatalogContext.create((Options)options));
        }
        return this.catalog;
    }

    protected void createTable() throws Exception {
        this.getCatalog().createDatabase(this.dataBaseName, true);
        this.getCatalog().createTable(this.identifier(), UnawareBucketCompactorTest.schema(), true);
    }

    protected Identifier identifier() {
        return Identifier.create((String)this.dataBaseName, (String)this.tableName);
    }

    protected static Schema schema() {
        Schema.Builder schemaBuilder = Schema.newBuilder();
        schemaBuilder.column("f0", (DataType)DataTypes.INT());
        schemaBuilder.column("f1", (DataType)DataTypes.INT());
        schemaBuilder.column("f2", (DataType)DataTypes.SMALLINT());
        schemaBuilder.column("f3", (DataType)DataTypes.STRING());
        schemaBuilder.column("f4", (DataType)DataTypes.DOUBLE());
        schemaBuilder.column("f5", (DataType)DataTypes.CHAR((int)100));
        schemaBuilder.column("f6", (DataType)DataTypes.VARCHAR((int)100));
        schemaBuilder.column("f7", (DataType)DataTypes.BOOLEAN());
        schemaBuilder.column("f8", (DataType)DataTypes.DATE());
        schemaBuilder.column("f10", (DataType)DataTypes.TIMESTAMP((int)9));
        schemaBuilder.column("f11", (DataType)DataTypes.DECIMAL((int)10, (int)2));
        schemaBuilder.column("f12", (DataType)DataTypes.BYTES());
        schemaBuilder.column("f13", (DataType)DataTypes.FLOAT());
        schemaBuilder.column("f14", (DataType)DataTypes.BINARY((int)10));
        schemaBuilder.column("f15", (DataType)DataTypes.VARBINARY((int)10));
        return schemaBuilder.build();
    }

    private static class MockCompactionTask
    extends UnawareAppendCompactionTask {
        public MockCompactionTask() {
            super(BinaryRow.EMPTY_ROW, Collections.emptyList());
        }

        public CommitMessage doCompact(FileStoreTable table, AppendOnlyFileStoreWrite write) throws Exception {
            Thread.sleep(125L);
            return null;
        }
    }
}

