/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.types.Row;
import org.apache.paimon.flink.CatalogITCaseBase;
import org.apache.paimon.utils.SnapshotNotExistException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CreateTagsProcedureITCase
extends CatalogITCaseBase {
    @Test
    public void testCreateTags() {
        this.sql("CREATE TABLE T ( k STRING, dt STRING, PRIMARY KEY (k, dt) NOT ENFORCED) PARTITIONED BY (dt) WITH ( 'bucket' = '1')", new Object[0]);
        this.sql("insert into T values('k', '2024-01-01')", new Object[0]);
        this.sql("insert into T values('k2', '2024-01-02')", new Object[0]);
        this.sql("CALL sys.create_tag('default.T', 'tag1')", new Object[0]);
        Assertions.assertThat(this.sql("select * from T /*+ OPTIONS('scan.tag-name'='tag1') */", new Object[0]).stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"+I[k2, 2024-01-02]", "+I[k, 2024-01-01]"});
        this.sql("CALL sys.create_tag('default.T', 'tag2', 1)", new Object[0]);
        Assertions.assertThat(this.sql("select * from T /*+ OPTIONS('scan.tag-name'='tag2') */", new Object[0]).stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"+I[k, 2024-01-01]"});
    }

    @Test
    public void testRenameTag() {
        this.sql("CREATE TABLE T ( k STRING, dt STRING, PRIMARY KEY (k, dt) NOT ENFORCED) PARTITIONED BY (dt) WITH ( 'bucket' = '1')", new Object[0]);
        this.sql("insert into T values('k', '2024-01-01')", new Object[0]);
        this.sql("insert into T values('k2', '2024-01-02')", new Object[0]);
        this.sql("CALL sys.create_tag('default.T', 'tag1')", new Object[0]);
        Assertions.assertThat(this.sql("select tag_name from `T$tags`", new Object[0]).stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"+I[tag1]"});
        this.sql("CALL sys.rename_tag('default.T', 'tag1', 'tag2')", new Object[0]);
        Assertions.assertThat(this.sql("select tag_name from `T$tags`", new Object[0]).stream().map(Row::toString)).containsExactlyInAnyOrder((Object[])new String[]{"+I[tag2]"});
    }

    @Test
    public void testThrowSnapshotNotExistException() {
        this.sql("CREATE TABLE T ( k STRING, dt STRING, PRIMARY KEY (k, dt) NOT ENFORCED) PARTITIONED BY (dt) WITH ( 'bucket' = '1')", new Object[0]);
        Assertions.assertThatException().isThrownBy(() -> this.sql("CALL sys.create_tag('default.T', 'tag1')", new Object[0])).withRootCauseInstanceOf(SnapshotNotExistException.class).withMessageContaining("Cannot create tag because latest snapshot doesn't exist.");
        Assertions.assertThatException().isThrownBy(() -> this.sql("CALL sys.create_tag('default.T', 'tag1', 1)", new Object[0])).withRootCauseInstanceOf(SnapshotNotExistException.class).withMessageContaining("Cannot create tag because given snapshot #1 doesn't exist.");
    }
}

