/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.sink.CompactionTaskSimpleSerializer;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.manifest.FileSource;
import org.apache.paimon.mergetree.compact.MergeTreeCompactManagerTest;
import org.apache.paimon.stats.StatsTestUtils;
import org.apache.paimon.table.sink.CompactionTaskSerializer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class CompactionTaskSimpleSerializerTest {
    private final CompactionTaskSerializer compactionTaskSerializer = new CompactionTaskSerializer();
    private final CompactionTaskSimpleSerializer serializer = new CompactionTaskSimpleSerializer(this.compactionTaskSerializer);
    private final BinaryRow partition = BinaryRow.EMPTY_ROW;

    @Test
    public void testSerializer() throws IOException {
        UnawareAppendCompactionTask task1 = new UnawareAppendCompactionTask(this.partition, this.newFiles(20));
        UnawareAppendCompactionTask task2 = this.serializer.deserialize(2, this.serializer.serialize(task1));
        Assertions.assertThat((Object)task1).isEqualTo((Object)task2);
    }

    private List<DataFileMeta> newFiles(int num) {
        ArrayList<DataFileMeta> list = new ArrayList<DataFileMeta>();
        for (int i = 0; i < num; ++i) {
            list.add(this.newFile());
        }
        return list;
    }

    private DataFileMeta newFile() {
        return new DataFileMeta(UUID.randomUUID().toString(), 0L, 1L, MergeTreeCompactManagerTest.row((int)0), MergeTreeCompactManagerTest.row((int)0), StatsTestUtils.newSimpleStats((int)0, (int)1), StatsTestUtils.newSimpleStats((int)0, (int)1), 0L, 1L, 0L, 0, Long.valueOf(0L), null, FileSource.APPEND, null);
    }
}

