/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.partition.actions.AddDonePartitionAction;
import org.apache.paimon.utils.PartitionPathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AddDonePartitionActionTest {
    AddDonePartitionActionTest() {
    }

    @Test
    public void test() throws Exception {
        final AtomicBoolean closed = new AtomicBoolean(false);
        final HashSet donePartitions = new HashSet();
        MetastoreClient metastoreClient = new MetastoreClient(){

            public void addPartition(LinkedHashMap<String, String> partition) {
                donePartitions.add(PartitionPathUtils.generatePartitionPath(partition));
            }

            public void addPartitions(List<LinkedHashMap<String, String>> partitions) {
                partitions.forEach(this::addPartition);
            }

            public void dropPartition(LinkedHashMap<String, String> partition) {
                throw new UnsupportedOperationException();
            }

            public void dropPartitions(List<LinkedHashMap<String, String>> partitions) {
                throw new UnsupportedOperationException();
            }

            public void markPartitionDone(LinkedHashMap<String, String> partitions) {
                throw new UnsupportedOperationException();
            }

            public void alterPartition(Partition partition) {
                throw new UnsupportedOperationException();
            }

            public void close() {
                closed.set(true);
            }
        };
        AddDonePartitionAction action = new AddDonePartitionAction(metastoreClient);
        action.markDone("dt=20201202");
        Assertions.assertThat(donePartitions).containsExactlyInAnyOrder((Object[])new String[]{"dt=20201202.done/"});
        action.markDone("dt=20201202/hour=02");
        Assertions.assertThat(donePartitions).containsExactlyInAnyOrder((Object[])new String[]{"dt=20201202.done/", "dt=20201202/hour=02.done/"});
        action.close();
        Assertions.assertThat((AtomicBoolean)closed).isTrue();
    }
}

