/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.partition.PartitionStatisticsReporter;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.metastore.MetastoreClient;
import org.apache.paimon.partition.Partition;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.shade.guava30.com.google.common.collect.Lists;
import org.apache.paimon.shade.guava30.com.google.common.collect.Maps;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.sink.BatchTableCommit;
import org.apache.paimon.table.sink.BatchTableWrite;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.PartitionPathUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PartitionStatisticsReporterTest {
    @TempDir
    java.nio.file.Path tempDir;

    @Test
    public void testReportAction() throws Exception {
        Path tablePath = new Path(this.tempDir.toString(), "table");
        SchemaManager schemaManager = new SchemaManager((FileIO)LocalFileIO.create(), tablePath);
        Schema schema = new Schema((List)Lists.newArrayList((Object[])new DataField[]{new DataField(0, "c1", (DataType)DataTypes.STRING()), new DataField(1, "c2", (DataType)DataTypes.STRING()), new DataField(2, "c3", (DataType)DataTypes.STRING())}), Collections.singletonList("c1"), Collections.emptyList(), (Map)Maps.newHashMap(), "");
        schemaManager.createTable(schema);
        final FileStoreTable table = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)tablePath);
        BatchTableWrite writer = table.newBatchWriteBuilder().newWrite();
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"a"), BinaryString.fromString((String)"a"), BinaryString.fromString((String)"a")}));
        writer.write((InternalRow)GenericRow.of((Object[])new Object[]{BinaryString.fromString((String)"b"), BinaryString.fromString((String)"a"), BinaryString.fromString((String)"a")}));
        List messages = writer.prepareCommit();
        BatchTableCommit committer = table.newBatchWriteBuilder().newCommit();
        committer.commit(messages);
        final AtomicBoolean closed = new AtomicBoolean(false);
        final HashMap partitionParams = Maps.newHashMap();
        MetastoreClient client = new MetastoreClient(){

            public void addPartition(LinkedHashMap<String, String> partition) {
                throw new UnsupportedOperationException();
            }

            public void addPartitions(List<LinkedHashMap<String, String>> partitions) {
                throw new UnsupportedOperationException();
            }

            public void dropPartition(LinkedHashMap<String, String> partition) {
                throw new UnsupportedOperationException();
            }

            public void dropPartitions(List<LinkedHashMap<String, String>> partitions) {
                throw new UnsupportedOperationException();
            }

            public void markPartitionDone(LinkedHashMap<String, String> partitionSpec) {
                throw new UnsupportedOperationException();
            }

            public void alterPartition(Partition partition) {
                partitionParams.put(PartitionPathUtils.generatePartitionPath((Map)partition.spec(), (RowType)table.rowType().project(table.partitionKeys())), partition);
            }

            public void close() {
                closed.set(true);
            }
        };
        PartitionStatisticsReporter action = new PartitionStatisticsReporter(table, client);
        long time = 1729598544974L;
        action.report("c1=a/", time);
        Assertions.assertThat((Map)partitionParams).containsKey((Object)"c1=a/");
        Assertions.assertThat((String)((Partition)partitionParams.get("c1=a/")).toString()).isEqualTo("{spec={c1=a}, recordCount=1, fileSizeInBytes=591, fileCount=1, lastFileCreationTime=1729598544974}");
        action.close();
        Assertions.assertThat((AtomicBoolean)closed).isTrue();
    }
}

