/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink.partition;

import java.nio.file.Path;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.partition.actions.SuccessFileMarkDoneAction;
import org.apache.paimon.partition.file.SuccessFile;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SuccessFileMarkDoneActionTest {
    @TempDir
    Path temp;

    SuccessFileMarkDoneActionTest() {
    }

    @Test
    public void test() throws Exception {
        LocalFileIO fileIO = new LocalFileIO();
        org.apache.paimon.fs.Path path = new org.apache.paimon.fs.Path(this.temp.toUri());
        SuccessFileMarkDoneAction action = new SuccessFileMarkDoneAction((FileIO)fileIO, path);
        org.apache.paimon.fs.Path successPath = new org.apache.paimon.fs.Path(path, "dt=20240513/_SUCCESS");
        action.markDone("dt=20240513");
        SuccessFile successFile1 = SuccessFile.safelyFromPath((FileIO)fileIO, (org.apache.paimon.fs.Path)successPath);
        Assertions.assertThat((Object)successFile1).isNotNull();
        Thread.sleep(100L);
        action.markDone("dt=20240513");
        SuccessFile successFile2 = SuccessFile.safelyFromPath((FileIO)fileIO, (org.apache.paimon.fs.Path)successPath);
        Assertions.assertThat((Object)successFile2).isNotNull();
        Assertions.assertThat((successFile1.creationTime() == successFile2.creationTime() ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((successFile1.modificationTime() < successFile2.modificationTime() ? 1 : 0) != 0).isTrue();
    }
}

