/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source.statistics;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.paimon.FileStore;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.fs.Path;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.predicate.PredicateBuilder;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.apache.paimon.table.sink.TableWriteImpl;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.VarCharType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class FileStoreTableStatisticsTestBase {
    protected final ObjectIdentifier identifier = ObjectIdentifier.of((String)"c", (String)"d", (String)"t");
    @TempDir
    java.nio.file.Path tempDir;
    protected Path tablePath;
    protected String commitUser;

    @BeforeEach
    public void before() {
        this.tablePath = new Path(this.tempDir.toString() + "/" + UUID.randomUUID());
        this.commitUser = UUID.randomUUID().toString();
    }

    @Test
    public void testTableScanStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        HashMap<String, ColStats> colStatsMap = new HashMap<String, ColStats>();
        colStatsMap.put("pt", ColStats.newColStats((int)0, (Long)2L, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (Long)0L, null, null));
        colStatsMap.put("a", ColStats.newColStats((int)1, (Long)9L, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(90), (Long)0L, null, null));
        colStatsMap.put("b", ColStats.newColStats((int)2, (Long)7L, (Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(900L), (Long)2L, null, null));
        colStatsMap.put("c", ColStats.newColStats((int)3, (Long)7L, (Comparable)BinaryString.fromString((String)"S1"), (Comparable)BinaryString.fromString((String)"S8"), (Long)2L, null, null));
        FileStore fileStore = table.store();
        FileStoreCommit fileStoreCommit = fileStore.newCommit(this.commitUser);
        Snapshot latestSnapshot = fileStore.snapshotManager().latestSnapshot();
        Statistics colStats = new Statistics(latestSnapshot.id(), latestSnapshot.schemaId(), Long.valueOf(9L), null, colStatsMap);
        fileStoreCommit.commitStatistics(colStats, Long.MAX_VALUE);
        fileStoreCommit.close();
        DataTableSource scanSource = new DataTableSource(this.identifier, (Table)table, false, null, null);
        Assertions.assertThat((long)scanSource.reportStatistics().getRowCount()).isEqualTo(9L);
        HashMap<String, ColumnStats> expectedColStats = new HashMap<String, ColumnStats>();
        expectedColStats.put("pt", ColumnStats.Builder.builder().setNdv(Long.valueOf(2L)).setMin((Comparable)Integer.valueOf(1)).setMax((Comparable)Integer.valueOf(2)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("a", ColumnStats.Builder.builder().setNdv(Long.valueOf(9L)).setMin((Comparable)Integer.valueOf(10)).setMax((Comparable)Integer.valueOf(90)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("b", ColumnStats.Builder.builder().setNdv(Long.valueOf(7L)).setMin((Comparable)Long.valueOf(100L)).setMax((Comparable)Long.valueOf(900L)).setNullCount(Long.valueOf(2L)).build());
        expectedColStats.put("c", ColumnStats.Builder.builder().setNdv(Long.valueOf(7L)).setMin((Comparable)BinaryString.fromString((String)"S1")).setMax((Comparable)BinaryString.fromString((String)"S8")).setNullCount(Long.valueOf(2L)).build());
        Assertions.assertThat((Map)scanSource.reportStatistics().getColumnStats()).isEqualTo(expectedColStats);
    }

    @Test
    public void testTableStreamingStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        DataTableSource streamSource = new DataTableSource(this.identifier, (Table)table, true, null, null);
        Assertions.assertThat((Object)streamSource.reportStatistics()).isEqualTo((Object)TableStats.UNKNOWN);
    }

    @Test
    public void testTableFilterPartitionStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource partitionFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.equal(0, (Object)1), (int[][])null, null, null, null, null);
        Assertions.assertThat((long)partitionFilterSource.reportStatistics().getRowCount()).isEqualTo(5L);
        HashMap<String, ColStats> colStatsMap = new HashMap<String, ColStats>();
        colStatsMap.put("pt", ColStats.newColStats((int)0, (Long)1L, (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2), (Long)0L, null, null));
        colStatsMap.put("a", ColStats.newColStats((int)1, (Long)5L, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(90), (Long)0L, null, null));
        colStatsMap.put("b", ColStats.newColStats((int)2, (Long)3L, (Comparable)Long.valueOf(100L), (Comparable)Long.valueOf(900L), (Long)2L, null, null));
        colStatsMap.put("c", ColStats.newColStats((int)3, (Long)3L, (Comparable)BinaryString.fromString((String)"S1"), (Comparable)BinaryString.fromString((String)"S7"), (Long)2L, null, null));
        FileStore fileStore = table.store();
        FileStoreCommit fileStoreCommit = fileStore.newCommit(this.commitUser);
        Snapshot latestSnapshot = fileStore.snapshotManager().latestSnapshot();
        Statistics colStats = new Statistics(latestSnapshot.id(), latestSnapshot.schemaId(), Long.valueOf(9L), null, colStatsMap);
        fileStoreCommit.commitStatistics(colStats, Long.MAX_VALUE);
        fileStoreCommit.close();
        HashMap<String, ColumnStats> expectedColStats = new HashMap<String, ColumnStats>();
        expectedColStats.put("pt", ColumnStats.Builder.builder().setNdv(Long.valueOf(1L)).setMin((Comparable)Integer.valueOf(1)).setMax((Comparable)Integer.valueOf(2)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("a", ColumnStats.Builder.builder().setNdv(Long.valueOf(5L)).setMin((Comparable)Integer.valueOf(10)).setMax((Comparable)Integer.valueOf(90)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("b", ColumnStats.Builder.builder().setNdv(Long.valueOf(3L)).setMin((Comparable)Long.valueOf(100L)).setMax((Comparable)Long.valueOf(900L)).setNullCount(Long.valueOf(2L)).build());
        expectedColStats.put("c", ColumnStats.Builder.builder().setNdv(Long.valueOf(3L)).setMin((Comparable)BinaryString.fromString((String)"S1")).setMax((Comparable)BinaryString.fromString((String)"S7")).setNullCount(Long.valueOf(2L)).build());
        Assertions.assertThat((Map)partitionFilterSource.reportStatistics().getColumnStats()).isEqualTo(expectedColStats);
    }

    @Test
    public void testTableFilterKeyStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource keyFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.equal(1, (Object)50), (int[][])null, null, null, null, null);
        Assertions.assertThat((long)keyFilterSource.reportStatistics().getRowCount()).isEqualTo(2L);
        HashMap<String, ColStats> colStatsMap = new HashMap<String, ColStats>();
        colStatsMap.put("pt", ColStats.newColStats((int)0, (Long)1L, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2), (Long)0L, null, null));
        colStatsMap.put("a", ColStats.newColStats((int)1, (Long)1L, (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(50), (Long)0L, null, null));
        colStatsMap.put("b", ColStats.newColStats((int)2, (Long)1L, null, null, (Long)1L, null, null));
        colStatsMap.put("c", ColStats.newColStats((int)3, (Long)1L, (Comparable)BinaryString.fromString((String)"S5"), (Comparable)BinaryString.fromString((String)"S5"), (Long)0L, null, null));
        FileStore fileStore = table.store();
        FileStoreCommit fileStoreCommit = fileStore.newCommit(this.commitUser);
        Snapshot latestSnapshot = fileStore.snapshotManager().latestSnapshot();
        Statistics colStats = new Statistics(latestSnapshot.id(), latestSnapshot.schemaId(), Long.valueOf(9L), null, colStatsMap);
        fileStoreCommit.commitStatistics(colStats, Long.MAX_VALUE);
        fileStoreCommit.close();
        HashMap<String, ColumnStats> expectedColStats = new HashMap<String, ColumnStats>();
        expectedColStats.put("pt", ColumnStats.Builder.builder().setNdv(Long.valueOf(1L)).setMin((Comparable)Integer.valueOf(2)).setMax((Comparable)Integer.valueOf(2)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("a", ColumnStats.Builder.builder().setNdv(Long.valueOf(1L)).setMin((Comparable)Integer.valueOf(50)).setMax((Comparable)Integer.valueOf(50)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("b", ColumnStats.Builder.builder().setNdv(Long.valueOf(1L)).setMin(null).setMax(null).setNullCount(Long.valueOf(1L)).build());
        expectedColStats.put("c", ColumnStats.Builder.builder().setNdv(Long.valueOf(1L)).setMin((Comparable)BinaryString.fromString((String)"S5")).setMax((Comparable)BinaryString.fromString((String)"S5")).setNullCount(Long.valueOf(0L)).build());
        Assertions.assertThat((Map)keyFilterSource.reportStatistics().getColumnStats()).isEqualTo(expectedColStats);
    }

    @Test
    public void testTableFilterValueStatistics() throws Exception {
        FileStoreTable table = this.writeData();
        PredicateBuilder builder = new PredicateBuilder(table.schema().logicalRowType());
        DataTableSource keyFilterSource = new DataTableSource(this.identifier, (Table)table, false, null, null, builder.greaterThan(2, (Object)500L), (int[][])null, null, null, null, null);
        Assertions.assertThat((long)keyFilterSource.reportStatistics().getRowCount()).isEqualTo(4L);
        HashMap<String, ColStats> colStatsMap = new HashMap<String, ColStats>();
        colStatsMap.put("pt", ColStats.newColStats((int)0, (Long)4L, (Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(2), (Long)0L, null, null));
        colStatsMap.put("a", ColStats.newColStats((int)1, (Long)4L, (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(50), (Long)0L, null, null));
        colStatsMap.put("b", ColStats.newColStats((int)2, (Long)4L, null, null, (Long)1L, null, null));
        colStatsMap.put("c", ColStats.newColStats((int)3, (Long)4L, (Comparable)BinaryString.fromString((String)"S5"), (Comparable)BinaryString.fromString((String)"S8"), (Long)0L, null, null));
        FileStore fileStore = table.store();
        FileStoreCommit fileStoreCommit = fileStore.newCommit(this.commitUser);
        Snapshot latestSnapshot = fileStore.snapshotManager().latestSnapshot();
        Statistics colStats = new Statistics(latestSnapshot.id(), latestSnapshot.schemaId(), Long.valueOf(9L), null, colStatsMap);
        fileStoreCommit.commitStatistics(colStats, Long.MAX_VALUE);
        fileStoreCommit.close();
        HashMap<String, ColumnStats> expectedColStats = new HashMap<String, ColumnStats>();
        expectedColStats.put("pt", ColumnStats.Builder.builder().setNdv(Long.valueOf(4L)).setMin((Comparable)Integer.valueOf(2)).setMax((Comparable)Integer.valueOf(2)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("a", ColumnStats.Builder.builder().setNdv(Long.valueOf(4L)).setMin((Comparable)Integer.valueOf(50)).setMax((Comparable)Integer.valueOf(50)).setNullCount(Long.valueOf(0L)).build());
        expectedColStats.put("b", ColumnStats.Builder.builder().setNdv(Long.valueOf(4L)).setMin(null).setMax(null).setNullCount(Long.valueOf(1L)).build());
        expectedColStats.put("c", ColumnStats.Builder.builder().setNdv(Long.valueOf(4L)).setMin((Comparable)BinaryString.fromString((String)"S5")).setMax((Comparable)BinaryString.fromString((String)"S8")).setNullCount(Long.valueOf(0L)).build());
        Assertions.assertThat((Map)keyFilterSource.reportStatistics().getColumnStats()).isEqualTo(expectedColStats);
    }

    protected FileStoreTable writeData() throws Exception {
        FileStoreTable table = this.createStoreTable();
        TableWriteImpl write = table.newWrite(this.commitUser);
        TableCommitImpl commit = table.newCommit(this.commitUser);
        write.write(this.rowData(1, 10, 100L, "S1"));
        write.write(this.rowData(1, 20, 200L, null));
        write.write(this.rowData(2, 30, 300L, "S3"));
        commit.commit(0L, write.prepareCommit(true, 0L));
        write.write(this.rowData(1, 40, 400L, "S4"));
        write.write(this.rowData(2, 50, null, "S5"));
        write.write(this.rowData(2, 60, 600L, "S6"));
        commit.commit(1L, write.prepareCommit(true, 1L));
        write.write(this.rowData(1, 70, 700L, "S7"));
        write.write(this.rowData(2, 80, null, "S8"));
        write.write(this.rowData(1, 90, 900L, null));
        commit.commit(2L, write.prepareCommit(true, 2L));
        write.close();
        commit.close();
        return table;
    }

    abstract FileStoreTable createStoreTable() throws Exception;

    protected InternalRow rowData(Object ... values) {
        return GenericRow.of((Object[])Arrays.stream(values).map(v -> {
            if (v instanceof String) {
                return BinaryString.fromString((String)((String)v));
            }
            return v;
        }).toArray());
    }

    protected Schema.Builder schemaBuilder() {
        return Schema.newBuilder().column("pt", (DataType)new IntType()).column("a", (DataType)new IntType()).column("b", (DataType)new BigIntType(true)).column("c", (DataType)new VarCharType(100));
    }
}

