/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.apache.flink.api.common.RuntimeExecutionMode;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.runtime.client.JobStatusMessage;
import org.apache.flink.runtime.testutils.MiniClusterResourceConfiguration;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.config.ExecutionConfigOptions;
import org.apache.flink.table.api.internal.TableEnvironmentImpl;
import org.apache.flink.table.operations.CollectModifyOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.paimon.flink.util.MiniClusterWithClientExtension;
import org.apache.paimon.utils.FileIOUtils;
import org.apache.paimon.utils.TimeUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.io.TempDir;

public class AbstractTestBase {
    private static final int DEFAULT_PARALLELISM = 16;
    @RegisterExtension
    protected static final MiniClusterWithClientExtension MINI_CLUSTER_EXTENSION = new MiniClusterWithClientExtension(new MiniClusterResourceConfiguration.Builder().setNumberTaskManagers(1).setNumberSlotsPerTaskManager(16).build());
    @TempDir
    protected static Path temporaryFolder;

    @AfterEach
    public final void cleanupRunningJobs() throws Exception {
        RestClusterClient<MiniClusterClient.MiniClusterId> clusterClient = MINI_CLUSTER_EXTENSION.createRestClusterClient();
        for (JobStatusMessage path : (Collection)clusterClient.listJobs().get()) {
            if (path.getJobState().isTerminalState()) continue;
            try {
                clusterClient.cancel(path.getJobId()).get();
            }
            catch (Exception exception) {}
        }
    }

    protected String getTempDirPath() {
        return this.getTempDirPath("");
    }

    protected String getTempDirPath(String dirName) {
        return this.createAndRegisterTempFile(dirName).toString();
    }

    protected String getTempFilePath(String fileName) {
        return this.createAndRegisterTempFile(fileName).toString();
    }

    protected String createTempFile(String fileName, String contents) throws IOException {
        File f = this.createAndRegisterTempFile(fileName);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        f.createNewFile();
        FileIOUtils.writeFileUtf8((File)f, (String)contents);
        return f.toString();
    }

    protected File createAndRegisterTempFile(String fileName) {
        return new File(temporaryFolder.toFile(), String.format("%s/%s", UUID.randomUUID(), fileName));
    }

    protected TableEnvironmentBuilder tableEnvironmentBuilder() {
        return new TableEnvironmentBuilder();
    }

    protected StreamExecutionEnvironmentBuilder streamExecutionEnvironmentBuilder() {
        return new StreamExecutionEnvironmentBuilder();
    }

    public static Transformation<?> translate(TableEnvironment env, String statement) {
        TableEnvironmentImpl envImpl = (TableEnvironmentImpl)env;
        List operations = envImpl.getParser().parse(statement);
        if (operations.size() != 1) {
            throw new RuntimeException("No operation after parsing for " + statement);
        }
        Operation operation = (Operation)operations.get(0);
        if (operation instanceof QueryOperation) {
            List transformations;
            QueryOperation queryOperation = (QueryOperation)operation;
            CollectModifyOperation sinkOperation = new CollectModifyOperation(queryOperation);
            try {
                Method translate = TableEnvironmentImpl.class.getDeclaredMethod("translate", List.class);
                translate.setAccessible(true);
                transformations = (List)translate.invoke((Object)envImpl, Collections.singletonList(sinkOperation));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            if (transformations.size() != 1) {
                throw new RuntimeException("No transformation after translating for " + statement);
            }
            return (Transformation)transformations.get(0);
        }
        throw new RuntimeException();
    }

    protected static class StreamExecutionEnvironmentBuilder {
        private boolean streamingMode = true;
        private Integer parallelism = null;
        private Integer checkpointIntervalMs = null;
        private boolean allowRestart = false;
        private Configuration conf = new Configuration();

        protected StreamExecutionEnvironmentBuilder() {
        }

        public StreamExecutionEnvironmentBuilder batchMode() {
            this.streamingMode = false;
            return this;
        }

        public StreamExecutionEnvironmentBuilder streamingMode() {
            this.streamingMode = true;
            return this;
        }

        public StreamExecutionEnvironmentBuilder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public StreamExecutionEnvironmentBuilder checkpointIntervalMs(int checkpointIntervalMs) {
            this.checkpointIntervalMs = checkpointIntervalMs;
            return this;
        }

        public StreamExecutionEnvironmentBuilder allowRestart() {
            this.allowRestart = true;
            return this;
        }

        public StreamExecutionEnvironmentBuilder allowRestart(boolean allowRestart) {
            this.allowRestart = allowRestart;
            return this;
        }

        public <T> StreamExecutionEnvironmentBuilder setConf(ConfigOption<T> option, T value) {
            this.conf.set(option, value);
            return this;
        }

        public StreamExecutionEnvironment build() {
            StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
            if (this.streamingMode) {
                env.setRuntimeMode(RuntimeExecutionMode.STREAMING);
                if (this.checkpointIntervalMs != null) {
                    env.getCheckpointConfig().setCheckpointingMode(CheckpointingMode.EXACTLY_ONCE);
                    env.getCheckpointConfig().setCheckpointInterval((long)this.checkpointIntervalMs.intValue());
                }
            } else {
                env.setRuntimeMode(RuntimeExecutionMode.BATCH);
            }
            if (this.parallelism != null) {
                env.setParallelism(this.parallelism.intValue());
            }
            Configuration conf = new Configuration();
            if (this.allowRestart) {
                conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
                conf.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)Integer.MAX_VALUE);
                conf.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofSeconds(1L));
            } else {
                conf.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"disable");
            }
            conf.addAll(this.conf);
            env.configure((ReadableConfig)conf);
            return env;
        }
    }

    protected static class TableEnvironmentBuilder {
        private boolean streamingMode = true;
        private Integer parallelism = null;
        private Integer checkpointIntervalMs = null;
        private int numRestarts = 0;
        private Configuration conf = new Configuration();

        protected TableEnvironmentBuilder() {
        }

        public TableEnvironmentBuilder batchMode() {
            this.streamingMode = false;
            return this;
        }

        public TableEnvironmentBuilder streamingMode() {
            this.streamingMode = true;
            return this;
        }

        public TableEnvironmentBuilder parallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public TableEnvironmentBuilder checkpointIntervalMs(int checkpointIntervalMs) {
            this.checkpointIntervalMs = checkpointIntervalMs;
            return this;
        }

        public TableEnvironmentBuilder allowRestart() {
            return this.allowRestart(Integer.MAX_VALUE);
        }

        public TableEnvironmentBuilder allowRestart(int numRestarts) {
            this.numRestarts = numRestarts;
            return this;
        }

        public <T> TableEnvironmentBuilder setConf(ConfigOption<T> option, T value) {
            this.conf.set(option, value);
            return this;
        }

        public TableEnvironmentBuilder setString(String key, String value) {
            this.conf.setString(key, value);
            return this;
        }

        public TableEnvironmentBuilder setConf(Configuration conf) {
            this.conf.addAll(conf);
            return this;
        }

        public TableEnvironment build() {
            TableEnvironment tEnv;
            if (this.streamingMode) {
                tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inStreamingMode().build());
                tEnv.getConfig().set(ExecutionConfigOptions.TABLE_EXEC_SINK_UPSERT_MATERIALIZE, (Object)ExecutionConfigOptions.UpsertMaterialize.NONE);
                if (this.checkpointIntervalMs != null) {
                    tEnv.getConfig().getConfiguration().setString("execution.checkpointing.interval", TimeUtils.formatWithHighestUnit((Duration)Duration.ofMillis(this.checkpointIntervalMs.intValue())));
                }
            } else {
                tEnv = TableEnvironment.create((EnvironmentSettings)EnvironmentSettings.newInstance().inBatchMode().build());
            }
            if (this.parallelism != null) {
                tEnv.getConfig().getConfiguration().set(ExecutionConfigOptions.TABLE_EXEC_RESOURCE_DEFAULT_PARALLELISM, (Object)this.parallelism);
            }
            if (this.numRestarts > 0) {
                tEnv.getConfig().getConfiguration().set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
                tEnv.getConfig().getConfiguration().set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, (Object)this.numRestarts);
                tEnv.getConfig().getConfiguration().set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofSeconds(1L));
            } else {
                tEnv.getConfig().getConfiguration().set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"disable");
            }
            tEnv.getConfig().getConfiguration().addAll(this.conf);
            return tEnv;
        }
    }
}

