/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.util.Preconditions;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataField;

public class DataCatalogTable
implements CatalogTable {
    private final Schema schema;
    private final List<String> partitionKeys;
    private final Map<String, String> options;
    private final String comment;
    private final Table table;
    private final Map<String, String> nonPhysicalColumnComments;

    public DataCatalogTable(Table table, Schema resolvedSchema, List<String> partitionKeys, Map<String, String> options, String comment, Map<String, String> nonPhysicalColumnComments) {
        this.schema = resolvedSchema;
        this.partitionKeys = (List)Preconditions.checkNotNull(partitionKeys, (String)"partitionKeys cannot be null");
        this.options = (Map)Preconditions.checkNotNull(options, (String)"options cannot be null");
        Preconditions.checkArgument((boolean)options.entrySet().stream().allMatch(e -> e.getKey() != null && e.getValue() != null), (Object)"properties cannot have null keys or values");
        this.comment = comment;
        this.table = table;
        this.nonPhysicalColumnComments = nonPhysicalColumnComments;
    }

    public Table table() {
        return this.table;
    }

    public Schema getUnresolvedSchema() {
        Map<String, String> columnComments = this.table.rowType().getFields().stream().filter(dataField -> dataField.description() != null).collect(Collectors.toMap(DataField::name, DataField::description));
        return this.toSchema(this.schema, columnComments);
    }

    private Schema toSchema(Schema tableSchema, Map<String, String> comments) {
        Schema.Builder builder = Schema.newBuilder();
        tableSchema.getColumns().forEach(column -> {
            Schema.UnresolvedPhysicalColumn c;
            if (column instanceof Schema.UnresolvedPhysicalColumn) {
                c = (Schema.UnresolvedPhysicalColumn)column;
                builder.column(c.getName(), c.getDataType());
            } else if (column instanceof Schema.UnresolvedMetadataColumn) {
                c = (Schema.UnresolvedMetadataColumn)column;
                builder.columnByMetadata(c.getName(), c.getDataType(), c.getMetadataKey(), c.isVirtual());
            } else if (column instanceof Schema.UnresolvedComputedColumn) {
                c = (Schema.UnresolvedComputedColumn)column;
                builder.columnByExpression(c.getName(), c.getExpression());
            } else {
                throw new IllegalArgumentException("Unsupported column type: " + column);
            }
            String colName = column.getName();
            if (comments.containsKey(colName)) {
                builder.withComment((String)comments.get(colName));
            } else if (this.nonPhysicalColumnComments.containsKey(colName)) {
                builder.withComment(this.nonPhysicalColumnComments.get(colName));
            }
        });
        tableSchema.getWatermarkSpecs().forEach(spec -> builder.watermark(spec.getColumnName(), spec.getWatermarkExpression()));
        if (tableSchema.getPrimaryKey().isPresent()) {
            Schema.UnresolvedPrimaryKey primaryKey = (Schema.UnresolvedPrimaryKey)tableSchema.getPrimaryKey().get();
            builder.primaryKeyNamed(primaryKey.getConstraintName(), primaryKey.getColumnNames());
        }
        return builder.build();
    }

    public CatalogBaseTable copy() {
        return new DataCatalogTable(this.table, this.schema, new ArrayList<String>(this.getPartitionKeys()), new HashMap<String, String>(this.getOptions()), this.getComment(), this.nonPhysicalColumnComments);
    }

    public CatalogTable copy(Map<String, String> options) {
        return new DataCatalogTable(this.table, this.schema, this.getPartitionKeys(), options, this.getComment(), this.nonPhysicalColumnComments);
    }

    public Optional<String> getDescription() {
        return Optional.of(this.getComment());
    }

    public Optional<String> getDetailedDescription() {
        return Optional.of("This is a catalog table in an im-memory catalog");
    }

    public boolean isPartitioned() {
        return !this.partitionKeys.isEmpty();
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }
}

