/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action;

import java.util.List;
import java.util.Map;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.action.TableActionBase;
import org.apache.paimon.operation.FileStoreCommit;
import org.apache.paimon.table.FileStoreTable;

public class DropPartitionAction
extends TableActionBase {
    private final List<Map<String, String>> partitions;
    private final FileStoreCommit commit;

    public DropPartitionAction(String databaseName, String tableName, List<Map<String, String>> partitions, Map<String, String> catalogConfig) {
        super(databaseName, tableName, catalogConfig);
        if (!(this.table instanceof FileStoreTable)) {
            throw new UnsupportedOperationException(String.format("Only FileStoreTable supports drop-partition action. The table type is '%s'.", this.table.getClass().getName()));
        }
        this.partitions = partitions;
        FileStoreTable fileStoreTable = (FileStoreTable)this.table;
        this.commit = fileStoreTable.store().newCommit(CoreOptions.createCommitUser(fileStoreTable.coreOptions().toConfiguration()));
    }

    @Override
    public void run() throws Exception {
        this.commit.dropPartitions(this.partitions, Long.MAX_VALUE);
    }
}

