/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.compact;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.metrics.MetricGroup;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.append.UnawareAppendCompactionTask;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.flink.metrics.FlinkMetricRegistry;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.operation.AppendOnlyFileStoreWrite;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.operation.metrics.MetricUtils;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.CommitMessage;
import org.apache.paimon.table.sink.TableCommitImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnawareBucketCompactor {
    private static final Logger LOG = LoggerFactory.getLogger(UnawareBucketCompactor.class);
    private final FileStoreTable table;
    private final String commitUser;
    private final transient AppendOnlyFileStoreWrite write;
    protected final transient Queue<Future<CommitMessage>> result;
    private final transient Supplier<ExecutorService> compactExecutorsupplier;
    @Nullable
    private final transient CompactionMetrics compactionMetrics;
    @Nullable
    private final transient CompactionMetrics.Reporter metricsReporter;

    public UnawareBucketCompactor(FileStoreTable table, String commitUser, Supplier<ExecutorService> lazyCompactExecutor, @Nullable MetricGroup metricGroup) {
        this.table = table;
        this.commitUser = commitUser;
        this.write = (AppendOnlyFileStoreWrite)table.store().newWrite(commitUser);
        this.result = new LinkedList<Future<CommitMessage>>();
        this.compactExecutorsupplier = lazyCompactExecutor;
        this.compactionMetrics = metricGroup == null ? null : new CompactionMetrics(new FlinkMetricRegistry(metricGroup), table.name());
        this.metricsReporter = this.compactionMetrics == null ? null : this.compactionMetrics.createReporter(BinaryRow.EMPTY_ROW, 0);
    }

    public void processElement(UnawareAppendCompactionTask task) throws Exception {
        this.result.add(this.compactExecutorsupplier.get().submit(() -> {
            MetricUtils.safeCall(this::startTimer, LOG);
            try {
                long startMillis = System.currentTimeMillis();
                CommitMessage commitMessage = task.doCompact(this.table, this.write);
                MetricUtils.safeCall(() -> {
                    if (this.metricsReporter != null) {
                        this.metricsReporter.reportCompactionTime(System.currentTimeMillis() - startMillis);
                        this.metricsReporter.increaseCompactionsCompletedCount();
                    }
                }, LOG);
                CommitMessage commitMessage2 = commitMessage;
                return commitMessage2;
            }
            finally {
                MetricUtils.safeCall(this::stopTimer, LOG);
                MetricUtils.safeCall(this::decreaseCompactionsQueuedCount, LOG);
            }
        }));
        this.recordCompactionsQueuedRequest();
    }

    private void recordCompactionsQueuedRequest() {
        if (this.metricsReporter != null) {
            this.metricsReporter.increaseCompactionsQueuedCount();
        }
    }

    private void decreaseCompactionsQueuedCount() {
        if (this.metricsReporter != null) {
            this.metricsReporter.decreaseCompactionsQueuedCount();
        }
    }

    private void startTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().start();
        }
    }

    private void stopTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().finish();
        }
    }

    public void close() throws Exception {
        this.shutdown();
        if (this.metricsReporter != null) {
            MetricUtils.safeCall(this.metricsReporter::unregister, LOG);
        }
        if (this.compactionMetrics != null) {
            MetricUtils.safeCall(this.compactionMetrics::close, LOG);
        }
    }

    @VisibleForTesting
    void shutdown() throws Exception {
        Future resultFuture;
        ArrayList<CommitMessage> messages = new ArrayList<CommitMessage>();
        Iterator iterator = this.result.iterator();
        while (iterator.hasNext() && (resultFuture = (Future)iterator.next()).isDone()) {
            try {
                messages.add((CommitMessage)resultFuture.get());
            }
            catch (Exception exception) {}
        }
        if (messages.isEmpty()) {
            return;
        }
        try (TableCommitImpl tableCommit = this.table.newCommit(this.commitUser);){
            tableCommit.abort(messages);
        }
    }

    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        ArrayList<CommitMessage> tempList = new ArrayList<CommitMessage>();
        try {
            Future<CommitMessage> future;
            while (!this.result.isEmpty() && ((future = this.result.peek()).isDone() || waitCompaction)) {
                this.result.poll();
                tempList.add(future.get());
            }
            return tempList.stream().map(s -> new Committable(checkpointId, Committable.Kind.FILE, s)).collect(Collectors.toList());
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while waiting tasks done.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an error while do compaction", e);
        }
    }

    public Iterable<Future<CommitMessage>> result() {
        return this.result;
    }
}

