/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.lookup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.serializer.InternalSerializers;
import org.apache.paimon.flink.lookup.FullCacheLookupTable;
import org.apache.paimon.lookup.BulkLoader;
import org.apache.paimon.lookup.RocksDBListState;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.utils.KeyProjectedRow;
import org.apache.paimon.utils.TypeUtils;

public class NoPrimaryKeyLookupTable
extends FullCacheLookupTable {
    private final long lruCacheSize;
    private final KeyProjectedRow joinKeyRow;
    private RocksDBListState<InternalRow, InternalRow> state;

    public NoPrimaryKeyLookupTable(FullCacheLookupTable.Context context, long lruCacheSize) {
        super(context);
        this.lruCacheSize = lruCacheSize;
        List<String> fieldNames = this.projectedType.getFieldNames();
        int[] joinKeyMapping = context.joinKey.stream().mapToInt(fieldNames::indexOf).toArray();
        this.joinKeyRow = new KeyProjectedRow(joinKeyMapping);
    }

    @Override
    public void open() throws Exception {
        this.init();
        this.state = this.stateFactory.listState("join-key-index", InternalSerializers.create(TypeUtils.project(this.projectedType, this.joinKeyRow.indexMapping())), InternalSerializers.create(this.projectedType), this.lruCacheSize);
        this.bootstrap();
    }

    @Override
    public List<InternalRow> innerGet(InternalRow key) throws IOException {
        return this.state.get(key);
    }

    @Override
    public void refresh(Iterator<InternalRow> incremental) throws IOException {
        if (this.userDefinedSeqComparator != null) {
            throw new IllegalArgumentException("Append table does not support user defined sequence fields.");
        }
        super.refresh(incremental);
    }

    @Override
    protected void refreshRow(InternalRow row, Predicate predicate) throws IOException {
        this.joinKeyRow.replaceRow(row);
        if (row.getRowKind() == RowKind.INSERT || row.getRowKind() == RowKind.UPDATE_AFTER) {
            if (predicate == null || predicate.test(row)) {
                this.state.add(this.joinKeyRow, row);
            }
        } else {
            throw new RuntimeException(String.format("Received %s message. Only INSERT/UPDATE_AFTER values are expected here.", new Object[]{row.getRowKind()}));
        }
    }

    @Override
    public byte[] toKeyBytes(InternalRow row) throws IOException {
        this.joinKeyRow.replaceRow(row);
        return this.state.serializeKey(this.joinKeyRow);
    }

    @Override
    public byte[] toValueBytes(InternalRow row) throws IOException {
        return this.state.serializeValue(row);
    }

    @Override
    public FullCacheLookupTable.TableBulkLoader createBulkLoader() {
        final BulkLoader bulkLoader = this.state.createBulkLoader();
        return new FullCacheLookupTable.TableBulkLoader(){
            private final List<byte[]> values = new ArrayList<byte[]>();
            private byte[] currentKey;

            @Override
            public void write(byte[] key, byte[] value) throws IOException {
                if (this.currentKey != null && !Arrays.equals(key, this.currentKey)) {
                    this.flush();
                }
                this.currentKey = key;
                this.values.add(value);
            }

            @Override
            public void finish() throws IOException {
                this.flush();
                bulkLoader.finish();
            }

            private void flush() throws IOException {
                if (this.currentKey != null && this.values.size() > 0) {
                    try {
                        bulkLoader.write(this.currentKey, NoPrimaryKeyLookupTable.this.state.serializeList(this.values));
                    }
                    catch (BulkLoader.WriteException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.currentKey = null;
                this.values.clear();
            }
        };
    }
}

