/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.HashMap;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.flink.action.CloneAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.StringUtils;

public class CloneProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "clone";

    @ProcedureHint(argument={@ArgumentHint(name="warehouse", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="database", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="catalog_conf", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_warehouse", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="target_database", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_table", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="target_catalog_conf", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="parallelism", type=@DataTypeHint(value="INT"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String warehouse, String database, String tableName, String sourceCatalogConfigStr, String targetWarehouse, String targetDatabase, String targetTableName, String targetCatalogConfigStr, Integer parallelismStr) throws Exception {
        HashMap<String, String> sourceCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(sourceCatalogConfigStr));
        if (!StringUtils.isNullOrWhitespaceOnly(warehouse) && !sourceCatalogConfig.containsKey("warehouse")) {
            sourceCatalogConfig.put("warehouse", warehouse);
        }
        HashMap<String, String> targetCatalogConfig = new HashMap<String, String>(this.optionalConfigMap(targetCatalogConfigStr));
        if (!StringUtils.isNullOrWhitespaceOnly(warehouse) && !targetCatalogConfig.containsKey("warehouse")) {
            targetCatalogConfig.put("warehouse", targetWarehouse);
        }
        CloneAction cloneAction = new CloneAction(database, tableName, sourceCatalogConfig, targetDatabase, targetTableName, targetCatalogConfig, parallelismStr == null ? null : Integer.toString(parallelismStr));
        return this.execute(procedureContext, cloneAction, "Clone Job");
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

