/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.flink.table.procedures.Procedure;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.flink.action.ActionBase;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;

public abstract class ProcedureBase
implements Procedure,
Factory {
    protected Catalog catalog;

    public ProcedureBase withCatalog(Catalog catalog) {
        this.catalog = catalog;
        return this;
    }

    protected Table table(String tableId) throws Catalog.TableNotExistException {
        return this.catalog.getTable(Identifier.fromString(tableId));
    }

    protected String notnull(@Nullable String arg) {
        return arg == null ? "" : arg;
    }

    @Nullable
    protected String nullable(String arg) {
        return StringUtils.isNullOrWhitespaceOnly(arg) ? null : arg;
    }

    protected String[] execute(ProcedureContext procedureContext, ActionBase action, String defaultJobName) throws Exception {
        StreamExecutionEnvironment env = procedureContext.getExecutionEnvironment();
        action.withStreamExecutionEnvironment(env);
        action.build();
        return this.execute(env, defaultJobName);
    }

    protected String[] execute(ProcedureContext procedureContext, JobClient jobClient) {
        StreamExecutionEnvironment env = procedureContext.getExecutionEnvironment();
        ReadableConfig conf = env.getConfiguration();
        return this.execute(jobClient, (Boolean)conf.get(TableConfigOptions.TABLE_DML_SYNC));
    }

    protected String[] execute(StreamExecutionEnvironment env, String defaultJobName) throws Exception {
        ReadableConfig conf = env.getConfiguration();
        String name = conf.getOptional(PipelineOptions.NAME).orElse(defaultJobName);
        return this.execute(env.executeAsync(name), (Boolean)conf.get(TableConfigOptions.TABLE_DML_SYNC));
    }

    private String[] execute(JobClient jobClient, boolean dmlSync) {
        String jobId = jobClient.getJobID().toString();
        if (dmlSync) {
            try {
                jobClient.getJobExecutionResult().get();
            }
            catch (Exception e) {
                throw new TableException(String.format("Failed to wait job '%s' finish", jobId), (Throwable)e);
            }
            return new String[]{"Success"};
        }
        return new String[]{"JobID=" + jobId};
    }

    protected Map<String, String> optionalConfigMap(String configStr) {
        if (StringUtils.isNullOrWhitespaceOnly(configStr)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> config = new HashMap<String, String>();
        for (String kvString : configStr.split(";")) {
            ParameterUtils.parseKeyValueString(config, kvString);
        }
        return config;
    }
}

