/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.source.abilities.SupportsDynamicFiltering;
import org.apache.flink.table.connector.source.abilities.SupportsStatisticReport;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.plan.stats.TableStats;
import org.apache.paimon.flink.log.LogStoreTableFactory;
import org.apache.paimon.flink.source.BaseDataTableSource;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.stats.ColStats;
import org.apache.paimon.stats.Statistics;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;

public class DataTableSource
extends BaseDataTableSource
implements SupportsStatisticReport,
SupportsDynamicFiltering {
    @Nullable
    private List<String> dynamicPartitionFilteringFields;

    public DataTableSource(ObjectIdentifier tableIdentifier, Table table, boolean streaming, DynamicTableFactory.Context context, @Nullable LogStoreTableFactory logStoreTableFactory) {
        this(tableIdentifier, table, streaming, context, logStoreTableFactory, null, null, null, null, null, null);
    }

    public DataTableSource(ObjectIdentifier tableIdentifier, Table table, boolean streaming, DynamicTableFactory.Context context, @Nullable LogStoreTableFactory logStoreTableFactory, @Nullable Predicate predicate, @Nullable int[][] projectFields, @Nullable Long limit, @Nullable WatermarkStrategy<RowData> watermarkStrategy, @Nullable List<String> dynamicPartitionFilteringFields, @Nullable Long countPushed) {
        super(tableIdentifier, table, streaming, context, logStoreTableFactory, predicate, projectFields, limit, watermarkStrategy, countPushed);
        this.dynamicPartitionFilteringFields = dynamicPartitionFilteringFields;
    }

    public DataTableSource copy() {
        return new DataTableSource(this.tableIdentifier, this.table, this.streaming, this.context, this.logStoreTableFactory, this.predicate, this.projectFields, this.limit, (WatermarkStrategy<RowData>)this.watermarkStrategy, this.dynamicPartitionFilteringFields, this.countPushed);
    }

    public TableStats reportStatistics() {
        Statistics statistics;
        if (this.streaming) {
            return TableStats.UNKNOWN;
        }
        Optional<Statistics> optionStatistics = this.table.statistics();
        if (optionStatistics.isPresent() && (statistics = optionStatistics.get()).mergedRecordCount().isPresent()) {
            Map<String, ColumnStats> flinkColStats = statistics.colStats().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), this.toFlinkColumnStats((ColStats)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            return new TableStats(statistics.mergedRecordCount().getAsLong(), flinkColStats);
        }
        this.scanSplitsForInference();
        return new TableStats(this.splitStatistics.totalRowCount());
    }

    public List<String> listAcceptedFilterFields() {
        return this.streaming ? Collections.emptyList() : this.table.partitionKeys();
    }

    public void applyDynamicFiltering(List<String> candidateFilterFields) {
        Preconditions.checkState(!this.streaming, "Cannot apply dynamic filtering to Paimon table '%s' when streaming reading.", this.table.name());
        Preconditions.checkState(!this.table.partitionKeys().isEmpty(), "Cannot apply dynamic filtering to non-partitioned Paimon table '%s'.", this.table.name());
        this.dynamicPartitionFilteringFields = candidateFilterFields;
    }

    @Override
    protected List<String> dynamicPartitionFilteringFields() {
        return this.dynamicPartitionFilteringFields;
    }

    private ColumnStats toFlinkColumnStats(ColStats<?> colStats) {
        return ColumnStats.Builder.builder().setNdv(colStats.distinctCount().isPresent() ? Long.valueOf(colStats.distinctCount().getAsLong()) : null).setNullCount(colStats.nullCount().isPresent() ? Long.valueOf(colStats.nullCount().getAsLong()) : null).setAvgLen(colStats.avgLen().isPresent() ? Double.valueOf(colStats.avgLen().getAsLong()) : null).setMaxLen(colStats.maxLen().isPresent() ? Integer.valueOf((int)colStats.maxLen().getAsLong()) : null).setMax(colStats.max().isPresent() ? colStats.max().get() : null).setMin(colStats.min().isPresent() ? colStats.min().get() : null).build();
    }
}

